package test

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

// go test -v dolphindb.go telegraf.go telegraf_test.go -test.run TestPreparePartitionedTableForTelegraf -count=1
func TestPreparePartitionedTableForTelegraf(t *testing.T) {
	Convey("PreparePartitionedTableForTelegraf", t, func() {
		cli := prepareClient(MetricCfg)
		defer dropClient(cli)

		db := loadOrNewDatabase(cli, MetricPartitionTableConfig.DatabaseRequest)
		prepareMemTable(cli, MetricPartitionTableConfig.MemTableRequest)
		preparePartitionedTable(cli, MetricPartitionTableConfig.DatabaseRequest.Directory, db, MetricPartitionTableConfig.PartitionedTableRequest)
	})
}

// go test -v dolphindb.go telegraf.go telegraf_test.go -test.run TestPrepareSecondPartitionedTableForTelegraf -count=1
func TestPrepareSecondPartitionedTableForTelegraf(t *testing.T) {
	Convey("TestPrepareSecondPartitionedTableForTelegraf", t, func() {
		cli := prepareClient(SecondMetricCfg)
		defer dropClient(cli)

		db := loadOrNewDatabase(cli, SecondMetricPartitionTableConfig.DatabaseRequest)
		prepareMemTable(cli, SecondMetricPartitionTableConfig.MemTableRequest)
		preparePartitionedTable(cli, SecondMetricPartitionTableConfig.DatabaseRequest.Directory, db, SecondMetricPartitionTableConfig.PartitionedTableRequest)
	})
}
