package outputs_test

import (
	"testing"

	"github.com/dolphindb/api-go/api"
	"github.com/influxdata/telegraf"
	"github.com/influxdata/telegraf/plugins/common/shim"
	. "github.com/smartystreets/goconvey/convey"

	. "github.com/dolphindb/go-plugins/internal/telegraf/outputs"
	"github.com/dolphindb/go-plugins/test"
)

func TestConnect(t *testing.T) {
	test.DoTestInPartitionTable(
		"TestConnect", t,
		test.MetricCfg, test.MetricPartitionTableConfig,
		func(cli api.DolphinDB, db *api.Database) {
			do := &DolphinDBOutput{
				Config: *test.MetricCfg,
				Log:    shim.NewLogger(),
			}

			err := do.Init()
			So(err, ShouldBeNil)
			err = do.Connect()
			So(err, ShouldBeNil)
			defer func() {
				err = do.Close()
				So(err, ShouldBeNil)
			}()

			m, _ := test.GenerateMetricEqualToTableColumn()
			err = do.Write([]telegraf.Metric{m})
			So(err, ShouldBeNil)
		})
}
