/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.streaming.client.AbstractClient;
import com.xxdb.streaming.client.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class TopicManager {
    private HashMap<String, TopicInfo> topicQueue = new HashMap();
    private static TopicManager uniqueInstance = null;

    private TopicManager() {
    }

    public static TopicManager getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new TopicManager();
        }
        return uniqueInstance;
    }

    private TopicInfo getTopicInfo(String topic) {
        if (this.topicQueue.containsKey(topic)) {
            return this.topicQueue.get(topic);
        }
        return null;
    }

    public boolean isTopicExists(String topic) {
        return this.topicQueue.containsKey(topic);
    }

    public synchronized void addTopic(String topic) {
        if (!this.topicQueue.containsKey(topic)) {
            this.topicQueue.put(topic, new TopicInfo(topic));
        }
    }

    public synchronized void removeTopic(String topic) {
        if (this.topicQueue.containsKey(topic)) {
            this.topicQueue.remove(topic);
        }
    }

    public ConcurrentHashMap<String, Integer> getNameToIndex(String topic) {
        TopicInfo ti = this.getTopicInfo(topic);
        if (ti != null) {
            return ti.nameToIndex;
        }
        return null;
    }

    public BlockingQueue<List<IMessage>> getMessageQueue(String topic) {
        TopicInfo ti = this.getTopicInfo(topic);
        BlockingQueue q = ti.messageQueue;
        return q;
    }

    public synchronized BlockingQueue<List<IMessage>> addMessageQueue(String topic) {
        TopicInfo ti = this.getTopicInfo(topic);
        if (ti != null && ti.messageQueue == null) {
            ti.messageQueue = new ArrayBlockingQueue(4096);
            return ti.messageQueue;
        }
        return null;
    }

    public List<String> getAllTopic() {
        Iterator<String> its = this.topicQueue.keySet().iterator();
        ArrayList<String> re = new ArrayList<String>();
        while (its.hasNext()) {
            re.add(its.next());
        }
        return re;
    }

    public AbstractClient.Site[] getSites(String topic) {
        TopicInfo ti = this.getTopicInfo(topic);
        AbstractClient.Site[] q = ti.sites;
        return q;
    }

    public String getTopic(String HATopic) {
        TopicInfo ti = this.getTopicInfo(HATopic);
        return ti.originTopic;
    }

    public void setSites(String topic, AbstractClient.Site[] sites) {
        TopicInfo ti = this.getTopicInfo(topic);
        TopicInfo.access$202(ti, sites);
    }

    public static class Utils {
        public static String getSiteFromTopic(String topic) {
            String site = topic.substring(0, topic.indexOf("/"));
            return site;
        }
    }

    private class SiteInfo {
        ConcurrentHashMap<String, TopicInfo> topicQueue = new ConcurrentHashMap();
        private int reconnectStat = 0;

        public void addTopic(String topic) {
            if (!this.topicQueue.containsKey(topic)) {
                this.topicQueue.put(topic, new TopicInfo(topic));
            }
        }

        public TopicInfo getTopic(String topic) {
            if (this.topicQueue.containsKey(topic)) {
                return this.topicQueue.get(topic);
            }
            return null;
        }

        public int getReconnectStat() {
            return this.reconnectStat;
        }

        public void setReconnectStat(int state) {
            this.reconnectStat = state;
        }
    }

    private class TopicInfo {
        private String originTopic;
        private BlockingQueue<List<IMessage>> messageQueue;
        private ConcurrentHashMap<String, Integer> nameToIndex;
        private AbstractClient.Site[] sites;
        private int reconnectStat;

        public TopicInfo(String topic) {
            this.originTopic = topic;
            this.reconnectStat = 0;
        }

        public void setOriginTopic(String originTopic) {
            this.originTopic = originTopic;
        }

        public String getOriginTopic() {
            return this.originTopic;
        }

        public void setNameToIndex(ConcurrentHashMap<String, Integer> nameToIndex) {
            this.nameToIndex = nameToIndex;
        }

        public ConcurrentHashMap<String, Integer> getNameToIndex() {
            return this.nameToIndex;
        }

        public void setReconnectStat(int stat) {
            this.reconnectStat = stat;
        }

        public int getReconnectStat() {
            return this.reconnectStat;
        }

        public void setSites(AbstractClient.Site[] sites) {
            this.sites = sites;
        }

        public AbstractClient.Site[] getSites() {
            return this.sites;
        }

        static /* synthetic */ AbstractClient.Site[] access$202(TopicInfo x0, AbstractClient.Site[] x1) {
            x0.sites = x1;
            return x1;
        }
    }
}

