/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.streaming.client;

import com.xxdb.DBConnection;
import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicArrayVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicStringVector;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.io.BigEndianDataOutputStream;
import com.xxdb.io.LittleEndianDataInputStream;
import com.xxdb.streaming.client.BasicMessage;
import com.xxdb.streaming.client.IMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;

public class StreamDeserializer {
    Map<String, MsgDeserializer> msgDeserializers_;
    Map<String, Pair<String, String>> tableNames_;

    public BasicMessage parse(IMessage message) throws Exception {
        if (message.size() < 3) {
            throw new RuntimeException("The data must contain 3 columns. ");
        }
        if (message.getEntity(1).getDataType() != Entity.DATA_TYPE.DT_SYMBOL && message.getEntity(1).getDataType() != Entity.DATA_TYPE.DT_STRING) {
            throw new RuntimeException("The 2rd column must be a vector type with symbol or string. ");
        }
        if (message.getEntity(2).getDataType() != Entity.DATA_TYPE.DT_BLOB) {
            throw new RuntimeException("The rd column must be a vector type with blob. ");
        }
        String sym = message.getEntity(1).getString();
        byte[] blob = ((BasicString)message.getEntity(2)).getBytes();
        MsgDeserializer deserializer = null;
        if (this.msgDeserializers_ != null) {
            if (!this.msgDeserializers_.containsKey(sym)) {
                throw new Exception("The filter " + sym + " does not exist. ");
            }
        } else {
            throw new RuntimeException("The StreamDeserialize is not inited");
        }
        deserializer = this.msgDeserializers_.get(sym);
        BasicMessage mixedMessage = new BasicMessage(message.getOffset(), message.getTopic(), deserializer.parse(blob), sym);
        return mixedMessage;
    }

    public StreamDeserializer(HashMap<String, List<Entity.DATA_TYPE>> filters) {
        this.msgDeserializers_ = new HashMap<String, MsgDeserializer>();
        for (Map.Entry<String, List<Entity.DATA_TYPE>> keyValue : filters.entrySet()) {
            List<Entity.DATA_TYPE> colTypes = keyValue.getValue();
            if (colTypes == null) {
                throw new RuntimeException("The colTypes can not be null");
            }
            this.msgDeserializers_.put(keyValue.getKey(), new MsgDeserializer(colTypes));
        }
    }

    public StreamDeserializer(Map<String, BasicDictionary> filters) {
        this.init(filters);
    }

    public StreamDeserializer(Map<String, Pair<String, String>> tableNames, DBConnection conn) {
        this.tableNames_ = tableNames;
        if (conn != null) {
            this.init(conn);
        }
    }

    public void init(DBConnection conn) {
        if (this.msgDeserializers_ != null) {
            throw new RuntimeException("The StreamDeserializer is inited. ");
        }
        if (this.tableNames_ == null) {
            throw new RuntimeException("The tableNames_ is null. ");
        }
        this.msgDeserializers_ = new HashMap<String, MsgDeserializer>();
        HashMap<String, BasicDictionary> filters = new HashMap<String, BasicDictionary>();
        for (Map.Entry<String, Pair<String, String>> keyValue : this.tableNames_.entrySet()) {
            String dbName = keyValue.getValue().getValue0();
            String tableName = keyValue.getValue().getValue1();
            BasicDictionary schema = null;
            try {
                if (dbName != null) {
                    schema = dbName.equals("") ? (BasicDictionary)conn.run("schema(" + tableName + ")") : (BasicDictionary)conn.run("schema(loadTable(\"" + dbName + "\",\"" + tableName + "\"))");
                }
                filters.put(keyValue.getKey(), schema);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.init(filters);
    }

    public void init(Map<String, BasicDictionary> filters) {
        this.msgDeserializers_ = new HashMap<String, MsgDeserializer>();
        for (Map.Entry<String, BasicDictionary> keyValue : filters.entrySet()) {
            ArrayList<Entity.DATA_TYPE> colTypes = new ArrayList<Entity.DATA_TYPE>();
            if (keyValue.getValue() == null) {
                throw new RuntimeException("The schema can not be null");
            }
            BasicTable colDefs = (BasicTable)keyValue.getValue().get("colDefs");
            BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
            for (int i = 0; i < colDefsTypeInt.rows(); ++i) {
                colTypes.add(Entity.DATA_TYPE.valueOf(colDefsTypeInt.getInt(i)));
            }
            this.msgDeserializers_.put(keyValue.getKey(), new MsgDeserializer(colTypes));
        }
    }

    public boolean isInited() {
        return this.msgDeserializers_ != null;
    }

    public void checkSchema(BasicDictionary schema) throws RuntimeException {
        BasicTable colDefs = (BasicTable)schema.get("colDefs");
        BasicStringVector types = (BasicStringVector)colDefs.getColumn(1);
        if (colDefs.rows() < 3) {
            throw new RuntimeException("The data must contain 3 columns. ");
        }
        if (!types.getString(1).equals("SYMBOL") && !types.getString(1).equals("STRING")) {
            throw new RuntimeException("The 2rd column must be a vector type with symbol or string. ");
        }
        if (!types.getString(2).equals("BLOB")) {
            throw new RuntimeException("The 3rd column must be a vector type with blob. ");
        }
    }

    class MsgDeserializer {
        List<Entity.DATA_TYPE> colTypes_ = new ArrayList<Entity.DATA_TYPE>();

        public MsgDeserializer(List<Entity.DATA_TYPE> colTypes) {
            this.colTypes_.addAll(colTypes);
        }

        public BasicAnyVector parse(byte[] data) throws Exception {
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            BigEndianDataOutputStream writeStream = new BigEndianDataOutputStream(memoryStream);
            writeStream.writeBlob(data);
            LittleEndianDataInputStream dataStream = new LittleEndianDataInputStream(new ByteArrayInputStream(memoryStream.toByteArray(), 0, memoryStream.size()));
            BasicEntityFactory basicEntityFactory = (BasicEntityFactory)BasicEntityFactory.instance();
            int columns = this.colTypes_.size();
            dataStream.readInt();
            BasicAnyVector ret = new BasicAnyVector(columns);
            for (int i = 0; i < columns; ++i) {
                if (this.colTypes_.get(i).getValue() >= Entity.DATA_TYPE.DT_BOOL_ARRAY.getValue() && this.colTypes_.get(i).getValue() <= Entity.DATA_TYPE.DT_DECIMAL128_ARRAY.getValue()) {
                    ret.setEntity(i, new BasicArrayVector(this.colTypes_.get(i), dataStream, 1, 0, -1).get(0));
                    continue;
                }
                ret.setEntity(i, basicEntityFactory.createEntity(Entity.DATA_FORM.DF_SCALAR, this.colTypes_.get(i), dataStream, false));
            }
            return ret;
        }
    }
}

