/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import java.util.ArrayList;
import java.util.List;

public class HashDomain
implements Domain {
    private int buckets;
    private Entity.DATA_TYPE type;
    private Entity.DATA_CATEGORY cat;

    public HashDomain(int buckets, Entity.DATA_TYPE type, Entity.DATA_CATEGORY cat) {
        this.buckets = buckets;
        this.type = type;
        this.cat = cat;
    }

    @Override
    public List<Integer> getPartitionKeys(Vector partitionCol) {
        if (partitionCol.getDataCategory() != this.cat) {
            throw new RuntimeException("Data category incompatible.");
        }
        if (this.cat == Entity.DATA_CATEGORY.TEMPORAL && this.type != partitionCol.getDataType()) {
            Entity.DATA_TYPE old = partitionCol.getDataType();
            if ((partitionCol = (Vector)Utils.castDateTime(partitionCol, this.type)) == null) {
                throw new RuntimeException("Can't convert type from " + old.name() + " to " + this.type.name());
            }
        }
        int rows = partitionCol.rows();
        ArrayList<Integer> keys = new ArrayList<Integer>(rows);
        for (int i = 0; i < rows; ++i) {
            keys.add(partitionCol.hashBucket(i, this.buckets));
        }
        return keys;
    }

    @Override
    public int getPartitionKey(Scalar partitionCol) {
        if (partitionCol.getDataCategory() != this.cat) {
            throw new RuntimeException("Data category incompatible.");
        }
        if (this.cat == Entity.DATA_CATEGORY.TEMPORAL && this.type != partitionCol.getDataType()) {
            Entity.DATA_TYPE old = partitionCol.getDataType();
            if ((partitionCol = (Scalar)Utils.castDateTime(partitionCol, this.type)) == null) {
                throw new RuntimeException("Can't convert type from " + (Object)((Object)old) + " to " + (Object)((Object)this.type));
            }
        }
        return partitionCol.hashBucket(this.buckets);
    }
}

