/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.route;

import com.xxdb.data.BasicAnyVector;
import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.route.Domain;
import com.xxdb.route.HashDomain;
import com.xxdb.route.ListDomain;
import com.xxdb.route.RangeDomain;
import com.xxdb.route.ValueDomain;

public class DomainFactory {
    public static Domain createDomain(Entity.PARTITION_TYPE type, Entity.DATA_TYPE partitionColType, Entity partitionSchema) throws Exception {
        if (type == Entity.PARTITION_TYPE.HASH) {
            Entity.DATA_TYPE dataType = partitionColType;
            Entity.DATA_CATEGORY dataCat = Utils.getCategory(dataType);
            int buckets = ((BasicInt)partitionSchema).getInt();
            return new HashDomain(buckets, dataType, dataCat);
        }
        if (type == Entity.PARTITION_TYPE.VALUE) {
            Entity.DATA_TYPE dataType = partitionSchema.getDataType();
            Entity.DATA_CATEGORY dataCat = Utils.getCategory(dataType);
            return new ValueDomain((Vector)partitionSchema, dataType, dataCat);
        }
        if (type == Entity.PARTITION_TYPE.RANGE) {
            Entity.DATA_TYPE dataType = partitionSchema.getDataType();
            Entity.DATA_CATEGORY dataCat = Utils.getCategory(dataType);
            return new RangeDomain((Vector)partitionSchema, dataType, dataCat);
        }
        if (type == Entity.PARTITION_TYPE.LIST) {
            Entity.DATA_TYPE dataType = partitionSchema.getDataType() == Entity.DATA_TYPE.DT_ANY ? ((BasicAnyVector)partitionSchema).getEntity(0).getDataType() : partitionSchema.getDataType();
            Entity.DATA_CATEGORY dataCat = Utils.getCategory(dataType);
            return new ListDomain((Vector)partitionSchema, dataType, dataCat);
        }
        throw new RuntimeException("Unsupported partition type " + type.toString());
    }
}

