/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.io;

import com.xxdb.io.AbstractExtendedDataInputStream;
import com.xxdb.io.Double2;
import com.xxdb.io.Long2;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInputStream
extends AbstractExtendedDataInputStream {
    public LittleEndianDataInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int readInt() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte b4 = this.readAndCheckByte();
        return this.fromBytes(b4, b3, b2, b1);
    }

    @Override
    public long readLong() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        byte b3 = this.readAndCheckByte();
        byte b4 = this.readAndCheckByte();
        byte b5 = this.readAndCheckByte();
        byte b6 = this.readAndCheckByte();
        byte b7 = this.readAndCheckByte();
        byte b8 = this.readAndCheckByte();
        return this.fromBytes(b8, b7, b6, b5, b4, b3, b2, b1);
    }

    @Override
    public Long2 readLong2() throws IOException {
        long low = this.readLong();
        long high = this.readLong();
        return new Long2(high, low);
    }

    @Override
    public Double2 readDouble2() throws IOException {
        double x = this.readDouble();
        double y = this.readDouble();
        return new Double2(x, y);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte b1 = this.readAndCheckByte();
        byte b2 = this.readAndCheckByte();
        return this.fromBytes((byte)0, (byte)0, b2, b1);
    }

    @Override
    public boolean isLittleEndian() {
        return true;
    }
}

