/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicLongMatrix;
import com.xxdb.data.BasicTimestamp;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicTimestampMatrix
extends BasicLongMatrix {
    public BasicTimestampMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicTimestampMatrix(int rows, int columns, List<long[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicTimestampMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setTimestamp(int row, int column, LocalDateTime value) {
        this.setLong(row, column, Utils.countMilliseconds(value));
    }

    public LocalDateTime getTimestamp(int row, int column) {
        return Utils.parseTimestamp(this.getLong(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicTimestamp(this.getLong(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIMESTAMP;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicTimestamp.class;
    }
}

