/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicTime;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicTimeVector
extends BasicIntVector {
    public BasicTimeVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicTimeVector(List<Integer> list) {
        super(list);
    }

    public BasicTimeVector(int[] array) {
        super(array);
    }

    protected BasicTimeVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicTimeVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicTimeVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_TIME;
    }

    @Override
    public Entity get(int index) {
        return new BasicTime(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicTimeVector(this.getSubArray(indices), false);
    }

    public LocalTime getTime(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseTime(this.getInt(index));
    }

    public void setTime(int index, LocalTime time) {
        this.setInt(index, Utils.countMilliseconds(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicTime.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicTimeVector v = (BasicTimeVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicTimeVector(newValue);
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicTimeVector)value).getdataArray());
    }
}

