/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicPoint;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.io.Double2;
import com.xxdb.io.ExtendedDataInput;
import com.xxdb.io.ExtendedDataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;

public class BasicPointVector
extends AbstractVector {
    protected Double2[] values;
    protected int size;
    protected int capaticy;

    public BasicPointVector(int size) {
        this(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicPointVector(List<Double2> list) {
        super(Entity.DATA_FORM.DF_VECTOR);
        if (list != null) {
            this.values = new Double2[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                this.values[i] = list.get(i) != null ? list.get(i) : new Double2(-1.7976931348623157E308, -1.7976931348623157E308);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    public BasicPointVector(Double2[] array) {
        this(array, true);
    }

    protected BasicPointVector(Double2[] array, boolean copy) {
        super(Entity.DATA_FORM.DF_VECTOR);
        this.values = copy ? (Double2[])array.clone() : array;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            this.values[i] = new Double2(-1.7976931348623157E308, -1.7976931348623157E308);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicPointVector(Entity.DATA_FORM df, int size) {
        super(df);
        this.values = new Double2[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = new Double2(0.0, 0.0);
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    protected BasicPointVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df);
        int len;
        int rows = in.readInt();
        int cols = in.readInt();
        int size = rows * cols;
        this.values = new Double2[size];
        long totalBytes = (long)size * 16L;
        boolean littleEndian = in.isLittleEndian();
        ByteOrder bo = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        for (long off = 0L; off < totalBytes; off += (long)len) {
            len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int start = (int)(off / 16L);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                double x = byteBuffer.getDouble(i * 16);
                double y = byteBuffer.getDouble(i * 16 + 8);
                this.values[i + start] = new Double2(x, y);
            }
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void deserialize(int start, int count, ExtendedDataInput in) throws IOException {
        long totalBytes = (long)count * 16L;
        long off = 0L;
        ByteOrder bo = in.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] buf = new byte[4096];
        while (off < totalBytes) {
            int len = (int)Math.min(4096L, totalBytes - off);
            in.readFully(buf, 0, len);
            int end = len / 16;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buf, 0, len).order(bo);
            for (int i = 0; i < end; ++i) {
                double x = byteBuffer.getDouble(i * 16);
                double y = byteBuffer.getDouble(i * 16 + 8);
                this.values[i + start] = new Double2(x, y);
            }
            off += (long)len;
            start += end;
        }
        this.size = this.values.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void serialize(int start, int count, ExtendedDataOutput out) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.writeDouble2(this.values[start + i]);
        }
    }

    @Override
    public Entity get(int index) {
        return new BasicPoint(this.values[index].x, this.values[index].y);
    }

    @Override
    public Vector getSubVector(int[] indices) {
        int length = indices.length;
        Double2[] sub = new Double2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return new BasicPointVector(sub, false);
    }

    protected Double2[] getSubArray(int[] indices) {
        int length = indices.length;
        Double2[] sub = new Double2[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.values[indices[i]];
        }
        return sub;
    }

    @Override
    public void set(int index, Entity value) throws Exception {
        this.values[index].x = ((BasicPoint)value).getX();
        this.values[index].y = ((BasicPoint)value).getY();
    }

    public void setPoint(int index, double x, double y) {
        this.values[index].x = x;
        this.values[index].y = y;
    }

    @Override
    public int hashBucket(int index, int buckets) {
        return this.values[index].hashBucket(buckets);
    }

    @Override
    public int getUnitLength() {
        return 16;
    }

    public void add(Double2 value) {
        if (this.size + 1 > this.capaticy && this.values.length > 0) {
            this.values = Arrays.copyOf(this.values, this.values.length * 2);
        } else if (this.values.length <= 0) {
            this.values = Arrays.copyOf(this.values, this.values.length + 1);
        }
        this.capaticy = this.values.length;
        this.values[this.size] = value;
        ++this.size;
    }

    public void addRange(Double2[] valueList) {
        this.values = Arrays.copyOf(this.values, valueList.length + this.values.length);
        System.arraycopy(valueList, 0, this.values, this.size, valueList.length);
        this.size += valueList.length;
        this.capaticy = this.values.length;
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(new Double2(((BasicPoint)value).getX(), ((BasicPoint)value).getY()));
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicPointVector)value).getdataArray());
    }

    public Double2[] getdataArray() {
        Double2[] data = new Double2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        return data;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicPointVector v = (BasicPointVector)vector;
        int newSize = this.rows() + v.rows();
        Double2[] newValue = new Double2[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicPointVector(newValue);
    }

    @Override
    public boolean isNull(int index) {
        return this.values[index].isNull();
    }

    @Override
    public void setNull(int index) {
        this.values[index].setNull();
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.BINARY;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_POINT;
    }

    @Override
    public Class<?> getElementClass() {
        return BasicPoint.class;
    }

    @Override
    public int rows() {
        return this.size;
    }

    @Override
    protected void writeVectorToOutputStream(ExtendedDataOutput out) throws IOException {
        Double2[] data = new Double2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        out.writeDouble2Array(data);
    }

    @Override
    public int asof(Scalar value) {
        throw new RuntimeException("BasicPointVector.asof not supported.");
    }

    @Override
    public ByteBuffer writeVectorToBuffer(ByteBuffer buffer) throws IOException {
        boolean isLittleEndian = buffer.order() == ByteOrder.LITTLE_ENDIAN;
        Double2[] data = new Double2[this.size];
        System.arraycopy(this.values, 0, data, 0, this.size);
        for (Double2 val : data) {
            if (isLittleEndian) {
                buffer.putDouble(val.x);
                buffer.putDouble(val.y);
                continue;
            }
            buffer.putDouble(val.y);
            buffer.putDouble(val.x);
        }
        return buffer;
    }

    @Override
    public int serialize(int indexStart, int offect, int targetNumElement, AbstractVector.NumElementAndPartial numElementAndPartial, ByteBuffer out) throws IOException {
        boolean isLittleEndian = out.order() == ByteOrder.LITTLE_ENDIAN;
        targetNumElement = Math.min(out.remaining() / this.getUnitLength(), targetNumElement);
        for (int i = 0; i < targetNumElement; ++i) {
            if (isLittleEndian) {
                out.putDouble(this.values[indexStart + i].x);
                out.putDouble(this.values[indexStart + i].y);
                continue;
            }
            out.putDouble(this.values[indexStart + i].y);
            out.putDouble(this.values[indexStart + i].x);
        }
        numElementAndPartial.numElement = targetNumElement;
        numElementAndPartial.partial = 0;
        return targetNumElement * 16;
    }
}

