/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.BasicMonth;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.YearMonth;
import java.util.List;

public class BasicMonthMatrix
extends BasicIntMatrix {
    public BasicMonthMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicMonthMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicMonthMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setMonth(int row, int column, YearMonth value) {
        this.setInt(row, column, Utils.countMonths(value));
    }

    public YearMonth getMonth(int row, int column) {
        return Utils.parseMonth(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicMonth(this.getInt(row, column));
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MONTH;
    }

    @Override
    public Class<?> getElementClass() {
        return YearMonth.class;
    }
}

