/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicMinute;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.data.Vector;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalTime;
import java.util.List;

public class BasicMinuteVector
extends BasicIntVector {
    public BasicMinuteVector(int size) {
        super(Entity.DATA_FORM.DF_VECTOR, size);
    }

    public BasicMinuteVector(List<Integer> list) {
        super(list);
    }

    public BasicMinuteVector(int[] array) {
        super(array);
    }

    public BasicMinuteVector(int[] array, boolean copy) {
        super(array, copy);
    }

    protected BasicMinuteVector(Entity.DATA_FORM df, int size) {
        super(df, size);
    }

    protected BasicMinuteVector(Entity.DATA_FORM df, ExtendedDataInput in) throws IOException {
        super(df, in);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_MINUTE;
    }

    @Override
    public Entity get(int index) {
        return new BasicMinute(this.getInt(index));
    }

    @Override
    public Vector getSubVector(int[] indices) {
        return new BasicMinuteVector(this.getSubArray(indices), false);
    }

    public LocalTime getMinute(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return Utils.parseMinute(this.getInt(index));
    }

    public void setMinute(int index, LocalTime time) {
        this.setInt(index, Utils.countMinutes(time));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicMinute.class;
    }

    @Override
    public Vector combine(Vector vector) {
        BasicMinuteVector v = (BasicMinuteVector)vector;
        int newSize = this.rows() + v.rows();
        int[] newValue = new int[newSize];
        System.arraycopy(this.values, 0, newValue, 0, this.rows());
        System.arraycopy(v.values, 0, newValue, this.rows(), v.rows());
        return new BasicMinuteVector(newValue);
    }

    @Override
    public void Append(Scalar value) throws Exception {
        this.add(value.getNumber().intValue());
    }

    @Override
    public void Append(Vector value) throws Exception {
        this.addRange(((BasicMinuteVector)value).getdataArray());
    }
}

