/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicDateTime;
import com.xxdb.data.BasicIntMatrix;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;

public class BasicDateTimeMatrix
extends BasicIntMatrix {
    public BasicDateTimeMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public BasicDateTimeMatrix(int rows, int columns, List<int[]> listOfArrays) throws Exception {
        super(rows, columns, listOfArrays);
    }

    public BasicDateTimeMatrix(ExtendedDataInput in) throws IOException {
        super(in);
    }

    public void setDateTime(int row, int column, LocalDateTime value) {
        this.setInt(row, column, Utils.countSeconds(value));
    }

    public LocalDateTime getDateTime(int row, int column) {
        return Utils.parseDateTime(this.getInt(row, column));
    }

    @Override
    public Scalar get(int row, int column) {
        return new BasicDateTime(this.getInt(row, column));
    }

    @Override
    public Class<?> getElementClass() {
        return BasicDateTime.class;
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATETIME;
    }
}

