/*
 * Decompiled with CFR 0.152.
 */
package com.xxdb.data;

import com.xxdb.data.BasicInt;
import com.xxdb.data.Entity;
import com.xxdb.data.Utils;
import com.xxdb.io.ExtendedDataInput;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;

public class BasicDate
extends BasicInt {
    public BasicDate(LocalDate value) {
        super(Utils.countDays(value));
    }

    public BasicDate(Calendar calendar) {
        super(Utils.countDays(calendar));
    }

    public BasicDate(ExtendedDataInput in) throws IOException {
        super(in);
    }

    protected BasicDate(int value) {
        super(value);
    }

    @Override
    public Entity.DATA_CATEGORY getDataCategory() {
        return Entity.DATA_CATEGORY.TEMPORAL;
    }

    @Override
    public Entity.DATA_TYPE getDataType() {
        return Entity.DATA_TYPE.DT_DATE;
    }

    public LocalDate getDate() {
        if (this.isNull()) {
            return null;
        }
        return Utils.parseDate(this.getInt());
    }

    @Override
    public Temporal getTemporal() throws Exception {
        return this.getDate();
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return "";
        }
        return this.getDate().format(DateTimeFormatter.ofPattern("yyyy.MM.dd"));
    }

    @Override
    public String getJsonString() {
        if (this.isNull()) {
            return "null";
        }
        return "\"" + this.getString() + "\"";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BasicDate) || o == null) {
            return false;
        }
        return this.getInt() == ((BasicDate)o).getInt();
    }
}

