/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.BindValue;
import com.dolphindb.jdbc.ColumnBindValue;
import com.dolphindb.jdbc.Driver;
import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.JDBCResultSet;
import com.dolphindb.jdbc.JDBCStatement;
import com.dolphindb.jdbc.TypeCast;
import com.dolphindb.jdbc.Utils;
import com.xxdb.data.AbstractVector;
import com.xxdb.data.BasicDictionary;
import com.xxdb.data.BasicEntityFactory;
import com.xxdb.data.BasicIntVector;
import com.xxdb.data.BasicString;
import com.xxdb.data.BasicTable;
import com.xxdb.data.Entity;
import com.xxdb.data.Scalar;
import com.xxdb.data.Vector;
import com.xxdb.data.Void;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JDBCPrepareStatement
extends JDBCStatement
implements PreparedStatement {
    private String preProcessedSql;
    private String tableName;
    private final int sqlDmlType;
    private List<ColumnBindValue> columnBindValues;
    private Map<Integer, Integer> insertIndexSQLToDDB;
    private Map<Integer, Integer> deleteIndexSQLToDDB;
    private BindValue[] bufferArea;
    private int batchSize = 0;
    private List<String> sqlBuffer;
    private List<String> cyclicSqlBuffer;
    private int deleteSqlCombinedNum;
    private List<String> varNames;
    private Map<String, Vector> deleteSqlMakeKeyStrategyVarVectorMap;
    private List<String> sqlColNames;
    private PrepareStatementDeleteStrategy deleteExecuteBatchStrategy;

    public JDBCPrepareStatement(JDBCConnection conn, String sql) throws SQLException {
        super(conn);
        this.connection = conn;
        this.preProcessedSql = this.preProcessSql(sql, conn);
        String[] sqlSplit = this.preProcessedSql.split(";");
        String lastStatement = sqlSplit.length == 0 ? "" : sqlSplit[sqlSplit.length - 1].trim();
        this.sqlDmlType = Utils.getDml(lastStatement);
        this.sqlBuffer = new ArrayList<String>();
        this.cyclicSqlBuffer = new ArrayList<String>();
        this.deleteSqlCombinedNum = 0;
        this.deleteSqlMakeKeyStrategyVarVectorMap = new HashMap<String, Vector>();
        this.sqlColNames = new ArrayList<String>();
        this.varNames = new ArrayList<String>();
        this.insertIndexSQLToDDB = new HashMap<Integer, Integer>();
        this.deleteIndexSQLToDDB = new HashMap<Integer, Integer>();
        if (this.sqlDmlType == 1) {
            if (sqlSplit.length != 1) {
                throw new SQLException("The INSERT statement must be a standalone statement.");
            }
            this.tableName = Utils.getTableName(this.preProcessedSql, true);
            this.initColumnBindValues(this.tableName);
            Utils.checkInsertSQLValid(this.preProcessedSql, this.columnBindValues.size());
            Map<String, Integer> columnParamInSql = Utils.getInsertColumnParamInSql(this.preProcessedSql);
            Iterator<Object> iterator = this.columnBindValues.iterator();
            while (iterator.hasNext()) {
                ColumnBindValue value = iterator.next();
                String colName = value.getColName();
                if (!columnParamInSql.containsKey(colName)) continue;
                this.insertIndexSQLToDDB.put(columnParamInSql.get(colName), value.getIndex());
                columnParamInSql.remove(colName);
            }
            if (columnParamInSql.size() != 0 && (iterator = columnParamInSql.keySet().iterator()).hasNext()) {
                String key = (String)iterator.next();
                throw new SQLException("The column name " + key + " does not exist in table. ");
            }
            this.bufferArea = new BindValue[this.columnBindValues.size()];
        } else if (this.sqlDmlType == 3) {
            this.tableName = Utils.getTableName(this.preProcessedSql, true);
            this.initColumnBindValues(this.tableName);
            Map<String, Integer> columnParamInSql = Utils.getDeleteColumnParamInSql(this.preProcessedSql);
            Iterator<Object> iterator = this.columnBindValues.iterator();
            while (iterator.hasNext()) {
                ColumnBindValue value = iterator.next();
                String colName = value.getColName();
                if (!columnParamInSql.containsKey(colName)) continue;
                this.deleteIndexSQLToDDB.put(columnParamInSql.get(colName), value.getIndex());
                columnParamInSql.remove(colName);
            }
            if (columnParamInSql.size() != 0 && (iterator = columnParamInSql.keySet().iterator()).hasNext()) {
                String key = (String)iterator.next();
                throw new SQLException("The column name " + key + " does not exist in table. ");
            }
            this.deleteExecuteBatchStrategy = Utils.getPrepareStmtDeleteSqlExecuteBatchStrategy(this.sqlDmlType, this.preProcessedSql, this.deleteIndexSQLToDDB);
            int size = 0;
            for (int i = 0; i < this.preProcessedSql.length(); ++i) {
                char ch = this.preProcessedSql.charAt(i);
                if (ch != '?') continue;
                ++size;
            }
            this.bufferArea = new BindValue[size];
        } else {
            int size = 0;
            for (int i = 0; i < this.preProcessedSql.length(); ++i) {
                char ch = this.preProcessedSql.charAt(i);
                if (ch != '?') continue;
                ++size;
            }
            this.bufferArea = new BindValue[size];
        }
    }

    private void initColumnBindValues(String tableName) throws SQLException {
        try {
            this.columnBindValues = new ArrayList<ColumnBindValue>();
            BasicDictionary schema = (BasicDictionary)this.connection.run(String.format("schema(%s)", tableName));
            BasicTable colDefs = (BasicTable)schema.get(new BasicString("colDefs"));
            AbstractVector names = (AbstractVector)colDefs.getColumn("name");
            BasicIntVector colDefsTypeInt = (BasicIntVector)colDefs.getColumn("typeInt");
            BasicIntVector extraInt = (BasicIntVector)colDefs.getColumn("extra");
            for (int i = 0; i < names.rows(); ++i) {
                String colName = names.getString(i).toLowerCase();
                int typeInt = colDefsTypeInt.getInt(i);
                Entity.DATA_TYPE type = Entity.DATA_TYPE.valueOf(typeInt);
                int extra = extraInt.getInt(i);
                ColumnBindValue columnBindValue = new ColumnBindValue(i, colName, type, extra);
                this.columnBindValues.add(columnBindValue);
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
        this.batchSize = 0;
        this.deleteSqlCombinedNum = 0;
        if (!this.varNames.isEmpty()) {
            this.varNames.clear();
        }
        if (!this.deleteSqlMakeKeyStrategyVarVectorMap.isEmpty()) {
            this.deleteSqlMakeKeyStrategyVarVectorMap.clear();
        }
        if (!this.sqlColNames.isEmpty()) {
            this.sqlColNames.clear();
        }
        if (this.sqlBuffer != null) {
            this.sqlBuffer.clear();
        }
        if (this.cyclicSqlBuffer != null) {
            this.cyclicSqlBuffer.clear();
        }
        if (this.columnBindValues != null) {
            this.columnBindValues.forEach(ColumnBindValue::clear);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] executeRes;
        try {
            if (this.sqlDmlType == 1) {
                executeRes = this.tableAppend();
            } else if (this.sqlDmlType == 3) {
                if (this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_IN) || this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_MAKEKEY) && this.batchSize >= 10) {
                    executeRes = new int[this.batchSize];
                    if (!this.varNames.isEmpty() && !this.deleteSqlMakeKeyStrategyVarVectorMap.isEmpty() && this.varNames.size() == this.deleteSqlMakeKeyStrategyVarVectorMap.size()) {
                        HashMap<String, Entity> map = new HashMap<String, Entity>();
                        for (int i = 0; i < this.sqlColNames.size(); ++i) {
                            map.put(this.varNames.get(i), this.deleteSqlMakeKeyStrategyVarVectorMap.get(this.sqlColNames.get(i).toLowerCase()));
                        }
                        this.connection.upload(map);
                    }
                    for (int i = 0; i < this.sqlBuffer.size(); ++i) {
                        try {
                            super.executeUpdate(this.sqlBuffer.get(i));
                            continue;
                        }
                        catch (Exception e) {
                            for (int j = 0; j < executeRes.length; ++j) {
                                executeRes[j] = j < i ? -2 : -3;
                            }
                            throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(executeRes, i));
                        }
                    }
                    Arrays.fill(executeRes, -2);
                } else {
                    executeRes = new int[this.batchSize];
                    for (int i = 0; i < this.batchSize; ++i) {
                        try {
                            super.executeUpdate(this.cyclicSqlBuffer.get(i));
                            continue;
                        }
                        catch (Exception e) {
                            for (int j = 0; j < executeRes.length; ++j) {
                                executeRes[j] = j < i ? -2 : -3;
                            }
                            throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(executeRes, i));
                        }
                    }
                    Arrays.fill(executeRes, -2);
                }
            } else {
                executeRes = new int[this.batchSize];
                for (int i = 0; i < this.batchSize; ++i) {
                    try {
                        executeRes[i] = super.executeUpdate(this.sqlBuffer.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        throw new BatchUpdateException(e.getMessage(), Arrays.copyOf(executeRes, i));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clearBatch();
        }
        return executeRes;
    }

    private void bind(int paramIndex, Object obj) throws SQLException {
        if (this.sqlDmlType == 1 || this.sqlDmlType == 3 && Objects.nonNull((Object)this.deleteExecuteBatchStrategy) && (this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_MAKEKEY) || this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_IN))) {
            int index = this.getDataIndexBySQLIndex(paramIndex);
            if (index >= this.columnBindValues.size()) {
                throw new SQLException("The index of columnBindValues is out of range.");
            }
            Vector column = this.columnBindValues.get(index).getBindValues();
            try {
                Entity data = BasicEntityFactory.createScalar(column.getDataType(), obj, this.columnBindValues.get(index).getScale());
                if (data.isScalar()) {
                    column.Append((Scalar)data);
                } else {
                    column.Append((Vector)data);
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.bufferArea[paramIndex - 1] = new BindValue(obj, false);
        } else {
            this.bufferArea[paramIndex - 1] = new BindValue(obj, false);
        }
    }

    private int getDataIndexBySQLIndex(int paramIndex) throws SQLException {
        int index = paramIndex - 1;
        if (this.sqlDmlType == 1) {
            if (this.insertIndexSQLToDDB.size() != 0) {
                if (!this.insertIndexSQLToDDB.containsKey(index)) {
                    throw new SQLException("paramIndex is out of range");
                }
                index = this.insertIndexSQLToDDB.get(index);
            }
        } else if (this.sqlDmlType == 3 && this.deleteIndexSQLToDDB.size() != 0) {
            if (!this.deleteIndexSQLToDDB.containsKey(index)) {
                throw new SQLException("paramIndex is out of range");
            }
            index = this.deleteIndexSQLToDDB.get(index);
        }
        return index;
    }

    private void bindNull(int paramIndex) throws SQLException {
        int index = this.getDataIndexBySQLIndex(paramIndex);
        if (this.sqlDmlType == 1 || this.sqlDmlType == 3 && Objects.nonNull((Object)this.deleteExecuteBatchStrategy) && (this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_MAKEKEY) || this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_IN))) {
            Vector column = this.columnBindValues.get(index).getBindValues();
            try {
                int typeValue = column.getDataType().getValue();
                if (typeValue < 65) {
                    column.Append((Scalar)TypeCast.nullScalar(this.columnBindValues.get(index).getType()));
                }
                Vector tmp = BasicEntityFactory.instance().createVectorWithDefaultValue(Entity.DATA_TYPE.valueOf(typeValue - 64), 0, 0);
                column.Append(tmp);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            this.bufferArea[paramIndex - 1] = new BindValue(TypeCast.nullScalar(this.columnBindValues.get(index).getType()), false);
        }
    }

    private void combineOneRowData(boolean isBatch) throws Exception {
        if (this.sqlDmlType == 1) {
            this.checkInsertBindsLegal(isBatch);
            if (isBatch) {
                for (ColumnBindValue column : this.columnBindValues) {
                    if (column.getBindValues().rows() == this.batchSize) continue;
                    Vector columnCol = column.getBindValues();
                    try {
                        if (columnCol.getDataType().getValue() < 65) {
                            columnCol.Append((Scalar)BasicEntityFactory.createScalar(columnCol.getDataType(), null, column.getScale()));
                            continue;
                        }
                        columnCol.Append((Vector)BasicEntityFactory.createScalar(columnCol.getDataType(), null, column.getScale()));
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
            }
        } else if (this.sqlDmlType == 3) {
            if (isBatch && Objects.nonNull((Object)this.deleteExecuteBatchStrategy)) {
                String[] splitSqls = null;
                splitSqls = this.preProcessedSql.split("where");
                StringBuilder builder = new StringBuilder();
                if (this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_IN)) {
                    builder.append(splitSqls[0]).append(" where ");
                    String colName = Utils.getDeleteColumnParamInSql(this.preProcessedSql).keySet().iterator().next();
                    builder.append(colName);
                    builder.append(" in ");
                    if (this.deleteSqlCombinedNum == 0) {
                        for (ColumnBindValue bindValue : this.columnBindValues) {
                            if (!bindValue.getColName().equals(colName)) continue;
                            this.sqlColNames.add(colName);
                            this.deleteSqlMakeKeyStrategyVarVectorMap.put(colName, bindValue.getBindValues());
                            String tempVar = "javaapi" + System.currentTimeMillis() + "_var" + 0;
                            this.varNames.add(tempVar);
                            builder.append(tempVar);
                        }
                    }
                } else {
                    builder.append(splitSqls[0]).append(" where makeKey(");
                    List partsList = Arrays.stream(this.preProcessedSql.split("\\s*(?=[!=><]|(?<!\\w)between\\b|(?<!\\w)and\\b|(?<!\\w)or\\b|(?<!\\w)in\\b(?!\\()|(?<!=)=)\\s*|\\s*(?<=[!=><]|(?<!\\w)between\\b|(?<!\\w)and\\b|(?<!\\w)or\\b|(?<!\\w)in\\b(?!\\()|=(?!=))\\s*")).filter(str -> !str.isEmpty()).collect(Collectors.toList());
                    for (int i = 0; i < partsList.size(); ++i) {
                        String[] words;
                        String lastWord;
                        String sqlPart = (String)partsList.get(i);
                        if ((sqlPart = sqlPart.trim()).equals("?") || sqlPart.equals("=") || sqlPart.equals("and") || !(lastWord = (words = sqlPart.split("[\\s,]+"))[words.length - 1]).equals("?") && i > 0 && ((String)partsList.get(i - 1)).equals("=") && words.length == 1 || lastWord.contains("?") || lastWord.equals("where")) continue;
                        if (!this.sqlColNames.isEmpty()) {
                            builder.append(", ");
                        }
                        if (this.deleteSqlCombinedNum == 0) {
                            this.sqlColNames.add(lastWord);
                        }
                        builder.append(lastWord);
                    }
                    builder.append(") in makeKey(");
                    if (this.deleteSqlCombinedNum == 0) {
                        int i;
                        for (ColumnBindValue column : this.columnBindValues) {
                            if (column.getBindValues().rows() == 0) continue;
                            this.deleteSqlMakeKeyStrategyVarVectorMap.put(column.getColName(), column.getBindValues());
                        }
                        for (i = 0; i < this.deleteSqlMakeKeyStrategyVarVectorMap.size(); ++i) {
                            String tempVar = "javaapi" + System.currentTimeMillis() + "_var" + i;
                            this.varNames.add(tempVar);
                            builder.append(tempVar);
                            if (i != this.deleteSqlMakeKeyStrategyVarVectorMap.size() - 1) {
                                builder.append(", ");
                                continue;
                            }
                            builder.append(") ");
                        }
                        for (i = 0; i < this.sqlColNames.size(); ++i) {
                            builder.append("and ").append(this.sqlColNames.get(i)).append(" in ").append(this.varNames.get(i)).append(" ");
                            if (i != this.sqlColNames.size() - 1) continue;
                            builder.append(";");
                        }
                    }
                    this.cyclicSqlBuffer.add(this.generateSQL());
                }
                if (this.deleteSqlCombinedNum == 0) {
                    this.sqlBuffer.add(builder.toString());
                }
                ++this.deleteSqlCombinedNum;
            } else {
                this.sqlBuffer.add(this.generate_single_execute_delete_sql());
            }
        } else {
            this.sqlBuffer.add(this.generateSQL());
        }
    }

    private void combineBindValueWithConditionSql(StringBuilder stringBuilder, String conditionSqlPart, String dmlSqlPart, boolean newSqlTag) throws SQLException {
        StringBuilder tempBuilder = new StringBuilder();
        String[] conditionSqlSplitByQuestionMark = conditionSqlPart.replaceAll(";", "").trim().split("\\?");
        if (this.bufferArea.length != 0) {
            tempBuilder.append(" (");
            for (int i = 0; i < this.bufferArea.length; ++i) {
                if (this.bufferArea[i] == null || this.bufferArea[i].getValue() == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                tempBuilder.append(conditionSqlSplitByQuestionMark[i]);
                tempBuilder.append(TypeCast.castDbString(this.bufferArea[i].getValue()));
                if (conditionSqlSplitByQuestionMark.length <= this.bufferArea.length || i != this.bufferArea.length - 1 || !Objects.nonNull(conditionSqlSplitByQuestionMark[i + 1])) continue;
                tempBuilder.append(conditionSqlSplitByQuestionMark[i + 1]);
            }
            tempBuilder.append(") ");
            if (stringBuilder.toString().length() + tempBuilder.toString().length() <= 65535) {
                if (newSqlTag) {
                    this.sqlBuffer.add(stringBuilder.append("where ").append((CharSequence)tempBuilder).toString());
                } else {
                    this.sqlBuffer.set(this.sqlBuffer.size() - 1, stringBuilder.append(" or ").append((CharSequence)tempBuilder).toString());
                }
            } else {
                if (dmlSqlPart.length() + tempBuilder.toString().length() > 65535) {
                    throw new RuntimeException("The delete sql's length rather than 65535 and where condition part is too long, cannot split into multi sqls to run.");
                }
                if (stringBuilder.toString().length() + tempBuilder.toString().length() > 65535) {
                    StringBuilder newSqlBuilder = new StringBuilder();
                    newSqlBuilder.append(dmlSqlPart);
                    this.combineBindValueWithConditionSql(newSqlBuilder, conditionSqlPart, dmlSqlPart, true);
                }
            }
        } else {
            stringBuilder.append(" where ").append(conditionSqlSplitByQuestionMark[0]);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.combineOneRowData(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            ResultSet resultSet = super.executeQuery(this.sqlBuffer.get(0));
            return resultSet;
        }
        finally {
            this.clearBatch();
        }
    }

    private void checkInsertBindsLegal(boolean isBatch) throws SQLException {
        int rows;
        int n = rows = isBatch ? this.batchSize : 1;
        if (this.insertIndexSQLToDDB.size() == 0) {
            for (ColumnBindValue bindValue : this.columnBindValues) {
                if (bindValue.getBindValues().rows() == rows) continue;
                throw new SQLException("The column " + bindValue.getColName() + " is not set.");
            }
        } else {
            for (Integer index : this.insertIndexSQLToDDB.keySet()) {
                if (this.columnBindValues.get(this.insertIndexSQLToDDB.get(index)).getBindValues().rows() == rows) continue;
                throw new SQLException("The column " + this.columnBindValues.get(this.insertIndexSQLToDDB.get(index)).getColName() + " is not set.");
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.combineOneRowData(false);
            if (this.sqlDmlType == 1) {
                int[] ret = this.tableAppend();
                if (ret[0] == -2) {
                    int n = 1;
                    return n;
                }
                int n = 0;
                return n;
            }
            int ret = super.executeUpdate(this.sqlBuffer.get(0));
            return ret;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            this.clearBatch();
        }
    }

    private int[] tableAppend() throws SQLException {
        List<Vector> arguments = this.createDFSArguments();
        ArrayList<String> colNames = new ArrayList<String>();
        this.columnBindValues.forEach(e -> colNames.add(e.getColName()));
        BasicTable basicTable = new BasicTable(colNames, arguments);
        ArrayList<Entity> param = new ArrayList<Entity>();
        param.add(basicTable);
        try {
            int size = ((Scalar)this.connection.run("tableInsert{" + this.tableName + "}", param)).getNumber().intValue();
            int[] value = new int[arguments.get(0).rows()];
            if (arguments.get(0).rows() != size) {
                Arrays.fill(value, -3);
            } else {
                Arrays.fill(value, -2);
            }
            return value;
        }
        catch (Exception e2) {
            throw new SQLException(e2);
        }
    }

    private List<Vector> createDFSArguments() {
        return this.columnBindValues.stream().map(ColumnBindValue::getBindValues).collect(Collectors.toList());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.sqlDmlType == 1 || this.sqlDmlType == 3 && Objects.nonNull((Object)this.deleteExecuteBatchStrategy) && (this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_MAKEKEY) || this.deleteExecuteBatchStrategy.equals((Object)PrepareStatementDeleteStrategy.COMBINE_SQL_WITH_IN))) {
            Object bindValue;
            this.bindNull(parameterIndex);
            switch (sqlType) {
                case 12: {
                    bindValue = "";
                    break;
                }
                case 1111: {
                    bindValue = new Void();
                    break;
                }
                default: {
                    bindValue = new Void();
                }
            }
            this.bufferArea[parameterIndex - 1] = new BindValue(bindValue, true);
        } else {
            Object bindValue;
            switch (sqlType) {
                case 12: {
                    bindValue = "";
                    break;
                }
                case 1111: {
                    bindValue = new Void();
                    break;
                }
                default: {
                    bindValue = new Void();
                }
            }
            this.bufferArea[parameterIndex - 1] = new BindValue(bindValue, true);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.bind(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.bind(parameterIndex, x.doubleValue());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setUnicodeStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void clearParameters() throws SQLException {
        Arrays.fill(this.bufferArea, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            switch (this.sqlDmlType) {
                case 0: 
                case 4: {
                    ResultSet resultSet_ = this.executeQuery();
                    this.resultSets.offerLast(resultSet_);
                    this.objectQueue.offer(resultSet_);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.objectQueue.offer(this.executeUpdate());
                    break;
                }
                default: {
                    this.combineOneRowData(false);
                    Entity entity = this.connection.run(this.sqlBuffer.get(0));
                    if (entity instanceof BasicTable) {
                        JDBCResultSet resultSet_ = new JDBCResultSet(this.connection, (JDBCStatement)this, entity, this.sqlBuffer.get(0), this.getMaxRows());
                        this.resultSets.offerLast(resultSet_);
                        this.objectQueue.offer(resultSet_);
                    }
                    this.clearBatch();
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        if (this.objectQueue.isEmpty()) {
            return false;
        }
        this.result = this.objectQueue.poll();
        return this.result instanceof ResultSet;
    }

    @Override
    public void addBatch() throws SQLException {
        ++this.batchSize;
        try {
            this.combineOneRowData(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        Driver.unused("setRef not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        byte[] blobbyte = x.getBytes(1L, (int)x.length());
        String blobstring = new String(blobbyte);
        this.bind(parameterIndex, blobstring);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        Driver.unused("setArray not implemented");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (Objects.nonNull(this.resultSet)) {
            return this.resultSet.getMetaData();
        }
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.bind(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Driver.unused("setNull not implemented");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        Driver.unused("setURL not implemented");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        Driver.unused("getParameterMetaData not implemented");
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        Driver.unused("setRowId not implemented");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.bind(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        Driver.unused("setSQLXML not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        Driver.unused("setAsciiStream not implemented");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        Driver.unused("setBinaryStream not implemented");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setCharacterStream not implemented");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        Driver.unused("setNCharacterStream not implemented");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setClob not implemented");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        Driver.unused("setBlob not implemented");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        Driver.unused("setNClob not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        Driver.unused("setObject not implemented");
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return 0L;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.columnBindValues = null;
        this.preProcessedSql = null;
        this.bufferArea = null;
    }

    private String preProcessSql(String sql, JDBCConnection con) {
        sql = Utils.changeCase(sql, con);
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if ((sql = sql.trim()).equals("select 1")) {
            sql = "select 1 as val";
        }
        return sql;
    }

    private String generateSQL() throws SQLException {
        if (Utils.isEmpty(this.preProcessedSql)) {
            throw new SQLException("preProcessedSql is null. ");
        }
        String[] sqlSplitByQuestionMark = this.preProcessedSql.split("\\?");
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bufferArea.length > sqlSplitByQuestionMark.length) {
            throw new SQLException("error size of bufferArea. ");
        }
        if (this.bufferArea.length != 0) {
            for (int i = 0; i < this.bufferArea.length; ++i) {
                if (this.bufferArea[i] == null || this.bufferArea[i].getValue() == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                stringBuilder.append(sqlSplitByQuestionMark[i]);
                stringBuilder.append(TypeCast.castDbString(this.bufferArea[i].getValue()));
                if (sqlSplitByQuestionMark.length <= this.bufferArea.length || i != this.bufferArea.length - 1 || !Objects.nonNull(sqlSplitByQuestionMark[i + 1])) continue;
                stringBuilder.append(sqlSplitByQuestionMark[i + 1]);
            }
        } else {
            stringBuilder.append(sqlSplitByQuestionMark[0]);
        }
        return stringBuilder.toString();
    }

    private String generate_single_execute_delete_sql() throws SQLException {
        if (Utils.isEmpty(this.preProcessedSql)) {
            throw new SQLException("preProcessedSql is null. ");
        }
        String[] sqlSplitByQuestionMark = this.preProcessedSql.split("\\?");
        StringBuilder stringBuilder = new StringBuilder();
        int size = 0;
        for (int i = 0; i < this.preProcessedSql.length(); ++i) {
            char ch = this.preProcessedSql.charAt(i);
            if (ch != '?') continue;
            ++size;
        }
        BindValue[] newBufferArea = new BindValue[size];
        System.arraycopy(this.bufferArea, 0, newBufferArea, 0, size);
        if (newBufferArea.length > sqlSplitByQuestionMark.length) {
            throw new SQLException("error size of bufferArea. ");
        }
        if (newBufferArea.length != 0) {
            for (int i = 0; i < newBufferArea.length; ++i) {
                if (newBufferArea[i] == null || newBufferArea[i].getValue() == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                stringBuilder.append(sqlSplitByQuestionMark[i]);
                stringBuilder.append(TypeCast.castDbString(newBufferArea[i].getValue()));
                if (sqlSplitByQuestionMark.length <= newBufferArea.length || i != newBufferArea.length - 1 || !Objects.nonNull(sqlSplitByQuestionMark[i + 1])) continue;
                stringBuilder.append(sqlSplitByQuestionMark[i + 1]);
            }
        } else {
            stringBuilder.append(sqlSplitByQuestionMark[0]);
        }
        return stringBuilder.toString();
    }

    public static enum PrepareStatementDeleteStrategy {
        CONCAT_SQL_CONDITION_WITH_OR("CONCAT_SQL_CONDITION_WITH_OR", 0),
        COMBINE_SQL_WITH_IN("COMBINE_SQL_WITH_IN", 1),
        COMBINE_SQL_WITH_MAKEKEY("COMBINE_SQL_WITH_MAKEKEY", 2),
        DEFAULT_DELETE_SQL_EXECUTE_STRATEGY("DEFAULT_DELETE_SQL_EXECUTE_STRATEGY", 3);

        private String name;
        private Integer code;

        private PrepareStatementDeleteStrategy(String name, Integer code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCode() {
            return this.code;
        }

        public static PrepareStatementDeleteStrategy getByName(String name) {
            for (PrepareStatementDeleteStrategy strategy : PrepareStatementDeleteStrategy.values()) {
                if (!strategy.getName().equals(name)) continue;
                return strategy;
            }
            throw new IllegalArgumentException("No matching PrepareStatementDeleteStrategy constant found for name: " + name);
        }
    }
}

