/*
 * Decompiled with CFR 0.152.
 */
package com.dolphindb.jdbc;

import com.dolphindb.jdbc.JDBCConnection;
import com.dolphindb.jdbc.Utils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static final String URL_PREFIX = "jdbc:dolphindb://";
    public static final String DB = "system_db";
    public static final Properties SYSTEM_PROPS = System.getProperties();
    public static final int V = 2;
    public static final int v = 0;
    private static final Logger LOGGER = Logger.getLogger("dolphindb");

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        return Driver.createConnection(url, properties);
    }

    @Override
    public boolean acceptsURL(String s) throws SQLException {
        return Driver.isValidURL(s);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOGGER;
    }

    public static boolean isValidURL(String url) {
        return url != null && url.toLowerCase().startsWith(URL_PREFIX);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Connection createConnection(String url, Properties prop) throws SQLException {
        if (!Driver.isValidURL(url)) {
            new SQLException("url is not valid");
        }
        String old_url = url;
        if ((url = url.trim().substring(URL_PREFIX.length())).length() == 0 || url.equals("?")) {
            prop.setProperty("hostName", "localhost");
            prop.setProperty("port", "8848");
            return new JDBCConnection(prop, old_url);
        }
        String[] strings = url.split("\\?");
        if (strings.length == 1) {
            String s = strings[0];
            if (s.length() <= 0) return new JDBCConnection(prop, old_url);
            if (s.contains("=")) {
                prop.setProperty("hostName", "localhost");
                prop.setProperty("port", "8848");
                Utils.parseProperties(s, prop, "&", "=");
                return new JDBCConnection(prop, old_url);
            } else {
                String[] hostname_port = s.split(":");
                if (hostname_port.length != 2) throw new SQLException("hostname_port " + strings[0] + " error");
                prop.setProperty("hostName", hostname_port[0]);
                prop.setProperty("port", hostname_port[1]);
            }
            return new JDBCConnection(prop, old_url);
        } else {
            if (strings.length != 2) return new JDBCConnection(prop, old_url);
            String s1 = strings[0];
            if (s1.length() > 0) {
                String[] hostname_port = s1.split(":");
                if (hostname_port.length != 2) throw new SQLException("hostname_port " + strings[0] + " error");
                prop.setProperty("hostName", hostname_port[0]);
                prop.setProperty("port", hostname_port[1]);
            } else {
                prop.setProperty("hostName", "localhost");
                prop.setProperty("port", "8848");
            }
            String s2 = strings[1];
            if (s2.length() <= 0) return new JDBCConnection(prop, old_url);
            Utils.parseProperties(s2, prop, "&", "=");
        }
        return new JDBCConnection(prop, old_url);
    }

    public static void unused(String s) throws SQLException {
        throw new SQLException(s);
    }

    public static void unused() throws SQLException {
        throw new SQLFeatureNotSupportedException("The current method is not supported.");
    }

    public static void unused(Exception e) throws SQLException {
        throw new SQLException(e.getMessage());
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

