# MDL_CFFEX_Level1模块说明
- 本模块支持: 
  - 订阅mdl cffex level 1实时行情数据
  - 实时合成5分钟K线
  - 每日盘后L1的数据流表入库
  - 每日盘后L1的csv文件入库

## 文件说明

## 步骤
### 1. 下载并加载MDL插件
```
listRemotePlugins()
installPlugin("mdl")
loadPlugin("mdl")
```

### 2. 上传模块
将文件夹MDL_CFFEX_LEVEL1上传至对应数据节点的modules路径下

```
// 预清理环境
use MDL_CFFEX_Level1::tools
MDL_CFFEX_Level1::tools::clearEnv()
```

### 3. 代码执行
#### 3.1 建库建表
```
use MDL_CFFEX_Level1::createTable

// 建立期货数据库表
dbName = "dfs://tlFut"
tbName = "cffex"
MDL_CFFEX_Level1::createTable::createFutureL1(dbName,tbName)


// 建立期货分钟线数据库表
dbName_KMin = "dfs://tlFutKMins"
tbName_KMin = "cffex"
MDL_CFFEX_Level1::createTable::createFutureL1_KMin(dbName_KMin,tbName_KMin)
```

#### 3.2 接收实时数据
```
use MDL_CFFEX_Level1::subscribe

// MDL客户端账SDK相关参数【支持级联】
host = 
port =
username = 

// 订阅L1行情数据
QuoteData = "L1_QuoteData"
MDL_CFFEX_Level1::subscribe::getCFFEXFutureData(QuoteData, host, port, username)
```

#### 3.3 实时合成分钟K线数据
```
use MDL_CFFEX_Level1::subscribe

// 合成Kmin
KlineData = "L1_minKlineData"
mins = 1 //合成K线周期
MDL_CFFEX_Level1::Kline::genKline(QuoteData, KlineData, mins)
```
执行后，会有五个共享字典作为数据字典使用，同时生成一个中间流表辅助计算。在合成过程中，请勿修改或删除。

#### 3.4 盘后：实时数据的流表入库
```
//期货L1入库
MDL_CFFEX_Level1::realToHis::CFFEXRealToHis_L1(QuoteData, dbName, tbName)
```
由于本模块计算的实时K线数据与mdl的k线数据计算方法不同，额外计算了iopv等字段，结果不完全一致，因此不提供k线流表入库转换语句。

#### 3.5 盘后：实时数据的csv文件入库
```
//期货L1
file_dir = "/home/data/mdl_7_1_0.csv"
MDL_CFFEX_Level1::realToHis::CFFEXRealToHisCSV(file_dir, dbName, tbName)

//期货KMin
file_dir = "/home/data/mdl_13_7_0.csv"
MDL_CFFEX_Level1::realToHis::CFFEXRealToHisCSV(file_dir, dbName_KMin, tbName_KMin)
```

#### 3.6 清理环境
当不需要使用本模块时，可以通过执行函数清理共享变量
```
use MDL_CFFEX_Level1::tools
MDL_CFFEX_Level1::tools::clearEnv(QuoteData,KlineData)
```
