# DolphinDB Python Parser {#py_par_intro}

## Introduction {#topic_xyz_ysj_s1c}

DolphinDB Python Parser interprets Python language and provides an execution environment for Python scripts. Unlike conventional Python, it is unrestricted by Global Interpreter Lock \(GIL\), unleashing the full potential of multi-core and distributed computing. By sharing the object system and runtime environment with DolphinDB scripts, Python Parser can directly access DolphinDB's storage engines and apply its built-in computing engine. Additionally, pandas, a third-party library for Python Parser, has been implemented. The following diagram briefly shows the structure of the script parsing system of DolphinDB.

![](images/0.1.png)

Based on Python 3.10, Python Parser currently supports the most commonly used syntax in Python. For details, please refer to Syntax. In addition to Python syntax, Python Parser is also compatible with DolphinDB's distinctive syntax and introduces extended syntax including SQL, enhancing its expressiveness, as illustrated in the following examples:

1.  In Python Parser, SQL query statements can be executed directly without using an API.

    ``` {#codeblock_oj2_csj_s1c}
    def query(t):
        return select count(*) from t
    ```

2.  As a built-in data type of Python Parser, temporal objects can be created directly with a literal constant \(e.g. `2012.06M`\), without entering `import datetime`. Currently, Python Parser is fully compatible with [constant data types in DolphinDB](DataTypesandStructures/DataTypesandStructures.dita).

    ``` {#codeblock_pws_fsj_s1c}
    month = 2012.06M
    ```


For details about extended Python Parser syntax, please refer to Extended Syntax.

**Note**: The current version of DolphinDB Python Parser is still in the Alpha trial phase.

## Differences from CPython {#topic_il3_rsj_s1c}

The fundamental difference between Python Parser and CPython lies in their object models. Python Parser shares the same object models with DolphinDB, enabling seamless integration between the two. For example, Python Parser implements integers in the same way as C++ implements `int`. In contrast, CPython implements integer objects based on `struct _longobject`, which contains both data and type information.

In addition, CPython initiates a new independent process for each execution. In comparison, Python Parser runs on the DolphinDB server. Therefore, before each execution, it is necessary to connect Python Parser to the server and create a session using client tools, such as GUI and Visual Studio Code \(VS Code\) Extension for DolphinDB.

## Differences from DolphinDB Python API {#topic_wjy_ssj_s1c}

Python API needs to be connected to the DolphinDB server in the Python environment before interacting with DolphinDB by executing DolphinDB scripts. In comparison, Python Parser runs directly on the DolphinDB server.

