# partition {#partition}

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

`partition(partitionCol, keys)`

## Arguments {#arguments}

**partitionCol** is a STRING indicating the partitioning column. For COMPO partitions, specify either of the partitioning columns.

**keys** is a scalar or vector without null values, indicating the partition\(s\) to select. Please refer to the following table about how to specify keys for each partition scheme:

|Partition Scheme|How to Specify keys|
|----------------|-------------------|
|VALUE|The associated element\(s\) in the partitioning vector|
|RANGE|The index of the associated partition\(s\), starting from 0|
|HASH|Hash modulus\(moduli\) of the partitioning column|
|LIST|The index of the associated partition\(s\), starting from 0|

Note: The partitions specified by *keys* must be within the partition range of the partitioned table, otherwise an error would occur indicating the specified keys are out of range.

## Details {#details}

Select one or more partitions from a partitioned table. It can only be used in the where clause of a SQL statement. This function makes it convenient to select specific partitions for HASH, LIST and RANGE partitions.

## Examples {#examples}

```
dbName="dfs://test_topic_partition"
if(existsDatabase(dbName)){
      dropDatabase(dbName)
}
db=database(dbName, LIST, ["A"+string(1..10), "A"+string(11..20), "A"+string(21..30)])
n=20
date=rand(2012.01.01..2012.01.10, n)
sym=rand("A"+string(1..30), n)
qty=rand(100, n)
t=table(date, sym, qty)
pt=db.createPartitionedTable(t, `pt, `sym).append!(t)
select * from pt where partition(sym, 0 1)
```

|date|sym|qty|
|----|---|---|
|2012.01.06|A4|32|
|2012.01.03|A10|34|
|2012.01.03|A17|51|
|2012.01.04|A14|47|
|2012.01.06|A16|50|
|2012.01.04|A15|56|
|2012.01.04|A16|80|
|2012.01.02|A11|69|
|2012.01.01|A14|68|

```
dbName="dfs://test_topic_partition"
if(existsDatabase(dbName)){
       dropDatabase(dbName)
}
db1=database("", HASH, [SYMBOL, 10])
db2=database("", LIST, ["A"+string(1..10), "B"+string(1..10), "C"+string(1..10)])
db=database(dbName, COMPO, [db1, db2])
n=20
id=symbol(string(rand(uuid(), n)))
sym=rand(["A"+string(1..10), "B"+string(1..10), "C"+string(1..10)].flatten(), n)
qty=rand(100, n)
t=table(id, sym, qty)
pt=db.createPartitionedTable(t, `pt, `id`sym).append!(t)
select * from pt where partition(id, 2 3), partition(sym, 1 2) order by id, sym, qty
```

|id|sym|vqty|
|---|---|----|
|19e8591f-8b7c-c611-bd3e-582d00a414430|C6|69|
|2db9074a-0502-27ad-06d5-8d1bf3270245|B4|2|
|73c1ae86-51c9-3e04-c1dd-6c4b62d8a129|B9|65|
|99d78d5e-14bb-dc7e-7210-7bc5ad0cda5d|C10|11|

