# notLike/NOTLIKE {#notlike_notlike}

The NOTLIKE is the inverse operation of LIKE, used to determine whether a specific character string does not match a specified pattern. It is equivalent to function [notLike](../../Functions/n/notlike.md) and predicate NOT LIKE. notLike supports both in-memory tables and DFS tables.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#topic_odt_321_d2c}

``` {#codeblock_qj2_m21_d2c}
match_expression notLike pattern
```

## Arguments {#topic_yb2_j21_d2c}

**match\_expression** Any valid expression of character data type.

**pattern** is a string \(case sensitive\) to be searched in *match\_expression*. The following wildcards can be used:

-   % represents zero, one or multiple characters.
-   ? represents one character.

If *match\_expression* does not match *pattern*, it returns true, otherwise returns false.

The notLike keyword is usually used in a where clause to filter data based on a specific pattern. For example, to select data that does not start with "A", does not end with "B", or does not contain "Ca".

## Examples {#topic_i1j_l21_d2c}

``` {#codeblock_rmr_p21_d2c}
t= table(`a1`a2`a3`b`b2`b3`ca1`ca2 as id, 7 4 NULL 1 8 NULL 12 NULL as val)
select * from t where id notLike "a%"
// equivalent to select * from t where id not like "a%"
```

|id|val|
|---|---|
|b|1|
|b2|8|
|b3| |
|ca1|12|
|ca2| |

Query records where the id column does not end with "b".

``` {#codeblock_bns_r21_d2c}
select * from t where id notLike "%b"
```

|id|val|
|---|---|
|a1|7|
|a2|4|
|a3| |
|b2|8|
|b3| |
|ca1|12|
|ca2| |

Query records where the id column does not contain “a“.

``` {#codeblock_ebw_s21_d2c}
select * from t where id notLike "%a%"
```

|id|val|
|---|---|
|b|1|
|b2|8|
|b3| |

