# like {#likelike}

like/LIKE is a logical operator that is used to retrieve the data in a column of a table, based on a specified pattern. It is equivalent to function [like](../../Functions/l/like.md).

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

```
match_expression [NOT] LIKE pattern
```

**match\_expression** is a column name or an expression containing column name.

**pattern** is a string \(case sensitive\) to be searched in *match\_expression*. The following wildcards can be used:

-   % represents zero, one or multiple characters.
-   ? represents one character.

If *match\_expression* matches pattern, it returns true, otherwise returns false. If "not" is specified, an opposite result is returned. The like keyword is usually used in a where clause to filter data based on a specific pattern. For example, to select data that starts with "A", ends with "B", or contains "Ca".

## Examples {#examples}

```sql
t= table(`a1`a2`a3`b1`b2`b3`c1`c2 as id, 7 4 NULL 1 8 NULL 12 NULL as val)
select * from t where id like "a%"
//equivalent to select * from t where like(id, "a%")
```

|id|val|
|---|---|
|a1|7|
|a2|4|
|a3||

```
select * from t where id not like "a%"
```

|id|val|
|---|---|
|b1|1|
|b2|8|
|b3||
|c1|12|
|c2||

