# is null {#is-null}

`is null` operator is used to test for null values, which is equivalent to the function [isNull](../../Functions/i/isNull.md).

`is not null` operator is used to test for non-empty values \(NOT null values\).

The SQL keywords `is null/is not null` support distributed queries to access data from DFS tables.

**Examples**

```
t= table(`a1`a2`a3`b1`b2`b3`c1`c2 as id, 7 4 NULL 1 8 NULL 12 NULL as val)
select id from t where val is null 
// equivalent to `select id from t where isNull(val)`
```

|id|
|---|
|a3|
|b3|
|c2|

```
select id from t where  val  is not null
// equivalent to `select id from t where not isNull(val)`
```

|id|
|---|
|a1|
|a2|
|b1|
|b2|
|c1|

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

