# in {#in}

The `in` operator is used to specify one or more values in a `where` clause. The `in` operator is a shorthand for multiple `or` conditions.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#in_syntax}

``` {#codeblock_s5y_5hn_ryb}
select col(s)
from table
where col [not] in (value1, value2, ...)
```

or

``` {#codeblock_u5y_5hn_ryb}
select col(s)
from table
where col [not] in (subquery)
```

## Arguments {#in_para}

**col\(s\)** is column name\(s\) to be selected.

**table** is the table name to be queried.

**col** is the column to be filtered.

**value1, value2, .../subquery** is the value\(s\) to be filtered.

## Examples {#emp_in}

``` {#codeblock_avy_5hn_ryb}
t = table(`APPL`AMZN`IBM`IBM`APPL`AMZN as sym, 1.8 2.3 3.7 3.1 4.2 2.8 as price);
select * from t where sym in (`APPL, `AMZN)
    // select * from t where sym=`APPL or sym=`AMZN
```

|sym|price|
|---|-----|
|APPL|1.8|
|AMZN|2.3|
|APPL|4.2|
|AMZN|2.8|

``` {#codeblock_cvy_5hn_ryb}
t1=table(`APPL`AMZN`IBM`IBM`APPL`AMZN as sym, 200 500 300 350 240 580 as vol);
select * from t where sym in (select sym from t1 where sym=`IBM)
```

|sym|price|
|---|-----|
|IBM|3.7|
|IBM|3.1|

