# exec {#exec}

The select statement always generates a table, even if only one column is selected. To generate a scalar or a vector from one column, use the exec statement.

When used with pivot by, exec generates a matrix. For details please refer to [pivot by](pivotBy.md).

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Examples {#examples}

```
sym = `C`MS`MS`MS`IBM`IBM`C`C`C$SYMBOL
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
t1 = table(timestamp, sym, qty, price);
t1;
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|09:34:07|C|2200|49.6|
|09:36:42|MS|1900|29.46|
|09:36:51|MS|2100|29.52|
|09:36:59|MS|3200|30.02|
|09:32:47|IBM|6800|174.97|
|09:35:26|IBM|5400|175.23|
|09:34:16|C|1300|50.76|
|09:34:26|C|2500|50.32|
|09:38:12|C|8800|51.29|

```
x = select count(price) from t1;
x;
```

|count\_price|
|------------|
|9|

```
typestr x;
// output: TABLE

y = exec count(price) from t1;
y;
// output: 9

typestr y;
// output: INT

x = select price from t1;
x;
```

|price|
|-----|
|49.6|
|29.46|
|29.52|
|30.02|
|174.97|
|175.23|
|50.76|
|50.32|
|51.29|

```
typestr x;
// output: TABLE
```

```
y = exec price from t1;
y;
// output: [49.6,29.46,29.52,30.02,174.97,175.23,50.76,50.32,51.29]

typestr y;
// output: FAST DOUBLE VECTOR
```

If we use the exec statement to select more than one column, the exec statement is identical as the select statement.

```
y = exec price, qty from t1;
y;
```

|price|qty|
|-----|---|
|49.6|2200|
|29.46|1900|
|29.52|2100|
|30.02|3200|
|174.97|6800|
|175.23|5400|
|50.76|1300|
|50.32|2500|
|51.29|8800|

```
typestr y;
// output: TABLE
```

