# drop {#drop}

The `drop` statement is used to drop a database or table.

## Drop DFS databases {#drop-dfs-databases}

### Syntax {#syntax}

``` {#codeblock_ofz_5hn_ryb}
drop database [if exists] dbPath
```

### Arguments {#arguments}

**dbPath** is a string indicating the path of a DFS database

### Examples {#examples}

``` {#codeblock_qfz_5hn_ryb}
drop database if exists "dfs://test"
```

Related functions: [dropDatabase](../../Functions/d/dropDatabase.md), [existsDatabase](../../Functions/e/existsDatabase.md)

## Drop DFS/dimension tables {#drop-dfsdimension-tables}

### Syntax {#syntax-1}

``` {#codeblock_sfz_5hn_ryb}
drop table [if exists] dbPath.tableName
```

### Arguments {#arguments-1}

**dbPath** is a string indicating the path of a DFS database.

**tableName** is a string indicating name of a DFS table or dimension table.

### Examples {#examples-1}

``` {#codeblock_wfz_5hn_ryb}
drop table if exists "dfs://test"."pt"
```

Related functions: [dropTable](../../Functions/d/dropTable.md), [existsTable](../../Functions/e/existsTable.md)

## Drop in-memory tables {#drop-in-memory-tables}

### Syntax {#syntax-2}

``` {#codeblock_yfz_5hn_ryb}
drop table [if exists] tableName
```

### Arguments {#arguments-2}

**tableName** is a string indicating the name of an in-memory table.

### Examples {#examples-2}

``` {#codeblock_agz_5hn_ryb}
drop table if exists "t"
```

Related functions: [undef](../../Functions/u/undef.md), [objs](../../Functions/o/objs.md)

