# distinct {#distinct}

The keyword distinct is used with the `select/exec` clause to eliminate all the duplicate records and return distinct values.

The SQL keyword `distinct` supports distributed queries to access data from DFS tables.

Note that the SQL keyword `distinct` differs from the distinct function in that the latter does not guarantee the order of the returned elements, and renames the columns in the result to "distinct\_colName" by default.

As of the current version, `distinct` cannot be used with `group by`, `context by` or `pivot by`.

**Parent topic:**[SQL Reference](../../Programming/SQLStatements/SQLStatement.md)

## Syntax {#syntax}

```python
select distinct col1, col2, ... 
from table
```

## Examples {#examples}

```python
t = table(`a`a`b`b`a`a`a`b as sym, 1 3 1 4 5 2 1 3 as id, 1..8 as value)
select distinct id from t
```

|id|
|---|
|1|
|3|
|4|
|5|
|2|

```python
select distinct id, sym from t
```

|id|sym|
|---|---|
|1|a|
|3|a|
|1|b|
|4|b|
|5|a|
|2|a|
|3|b|

