# getTraces {#gettraces}

**Parent topic:**[SQL Trace](../../../Programming/SQLStatements/SQLTrace/SQLTrace.md)

## Syntax {#syntax}

getTraces\(\)

## Arguments {#arguments}

None

## Details {#details}

Return a table containing the information of all SQL traces. It has the following columns:

-   time: the timestamp at which the client submits the script to server

-   scripts: the script sent to the server by the client. Some scripts \(such as "objs11" in the example below\) represent the internal operations of the client and can be ignored.

-   traceId: The ID of a trace. Use trace ID to get the complete tracing information of a script with viewTraceInfo.

-   sessionId: The ID of the session that started the SQL tracing.


## Examples {#examples}

```
getTraces();
```

|time|scripts|traceId|sessionId|
|----|-------|-------|---------|
|2022.09.26T08:50:48.486114674|setTraceMode\(false\)|db80c71c-51e4-4fa5-524c-8230a9e14259|2,333,906,441|
|2022.09.26T08:50:45.202118926|\[n,db,\[0, 0\]\]|078cafbc-003c-6495-e248-58f111d973c4|2,333,906,441|
|2022.09.26T08:50:45.196684636|objs11|50e9d859-2d4d-368d-c641-71f239325926|2,333,906,441|
|2022.09.26T08:50:45.150871346|login\(\`admin, \`123456\)if\(existsDatabase\("dfs://tedb"\)\)\{ dropDatabase\("dfs://tedb"\)\}n=30ticker = rand\(\`MSFT\`GOOG\`FB\`ORCL\`IBM\`PPT\`AZH\`ILM\`ANZ,n\);id = rand\(\`A\`B\`C, n\)x=rand\(1.0, n\)t=table\(ticker, id, x\)select \*, x&gt;0.5 as x1 from tdb=database\(directory="dfs://tedb", partitionType=HASH, partitionScheme=\[STRING, 5\]\)pt = db.createPartitionedTable\(t, \`pt, \`ticker\)pt.append!\(t\)update t set x = 1 where id = \`A|64ae3ac9-3963-6eab-c244-48bd1c0adc80|2,333,906,441|
|2022.09.26T08:50:37.921672908|objs11|a2c39b23-8260-1cb7-ab4b-205429c0c60d|2,333,906,441|

