# Include {#include}

**Parent topic:**[Programming Statements](../../Programming/ProgrammingStatements/programming_statements.md)

## Syntax {#syntax}

\#include "file path"

## Arguments {#arguments}

"file path" can be either the absolutely path or the relative path of a file.

## Details {#details}

Statement \#include imports users' scripts. It cannot be used in a console.

## Examples {#examples}

The example below shows how the script "GetTable.txt" imports a script called "GenTradeTable.txt" that is located in the directory "/home/test/".

The content of GenTradeTable.txt:

```
n=2000
syms=`YHOO`GE`MS`MSFT`JPM`ORCL`CISCO
timestamp=09:30:00+rand(18000, n)
sym=rand(syms, n)
qty=100*(1+rand(100,n))
price=5.0+rand(100.0, n)
t1=table(timestamp,sym,qty,price);
```

The content of GetTable.txt:

```
#include "/home/test/GenTradeTable.txt"
t1;
```

Execute the following statement:

```
run "GetTable.txt";
```

|timestamp|sym|qty|price|
|---------|---|---|-----|
|12:19:25|YHOO|9500|93.307309|
|11:02:57|GE|8400|52.797873|
|10:04:09|CISO|1700|57.467623|
|12:01:23|JPM|8300|70.12557|
|14:22:02|MS|7900|44.220769|
|...|...|...|...|

