# Multiple Assignment {#multiple-assignment}

Multiple values can be assigned to multiple variables all at once.

```
x,y=1 2 3, 2:5;
x;
// output: [1,2,3]
y;
// output: 2 : 5

x,y=(1 2 3, 2:5);
x;
// output: [1,2,3]
y;
// output: 2 : 5

// multiple assignments by functions returning more than one value
def foo(a,b): [a+b, a-b]
x,y = foo(15,10);
x;
// output: 25
y;
// output: 5

// multiple assignments from the same value
x,y=10;
x;
// output: 10
y;
// output: 10

// Multiple assignments using columns from a matrix. The variables will take columns from the matrix sequentially. The number of variables must be the same as the number of columns in the matrix.
x,y = 1..10$5:2;
x;
// output: [1,2,3,4,5]
y;
// output: [6,7,8,9,10]

// Multiple assignments using rows from a table. The variables will take rows from the table sequentially. The number of variables must be the same as the number of rows in the table.
t = table(1 2 3 as id, 4 5 6 as value, `IBM`MSFT`GOOG as name);
t;
```

|id|value|name|
|---|-----|----|
|1|4|IBM|
|2|5|MSFT|
|3|6|GOOG|

```
a,b,c = t;
a;
/* output
name->IBM
value->4
id->1
*/

b;
/* output
name->MSFT
value->5
id->2
*/

c;
/* output
name->GOOG
value->6
id->3
*/
```

**Parent topic:**[Assignment](../../../Programming/ProgrammingStatements/Assignment/Assignment.md)

