# Precedence Rules {#precedence-rules}

DolphinDB uses common sense operator precedence. The precedences of frequently used operators are similar to most programming languages. The operator with the highest priority will be executed first in an expression. Operators with equal priorities are executed from left to right.

```
a=5;
3+a*a;
// output: 28
// 3+(a*a)

3*a..10;
// output: [15,18,21,24,27,30]
// 3*(a..10)
```

It might be confusing to use a binary operator on the right side of a unary operator. For example, abs x - 10 could be interpreted as abs\(x-10\) or abs\(x\) - 10. We use the first interpretation, i.e. unary operators treat the entire expression to the right as the operand. We encourage users to use parenthesis in functions to avoid ambiguity.

For another example, avg sin abs -100..100 is equivalent to avg\(sin\(abs\(-100..100\)\)\)

```
avg sin abs -100..100;
// output: -0.001265

avg(sin(abs(-100..100)));
// output: -0.001265

sum 1 2 3 == 6;
// output: 0
// equivalent to sum(1 2 3 == 6)

x = 10
sin(x) + cos(x);
// output: -1.383093

sin x + cos x;
// output: 0.260799
// equivalent to sin(x+cos x)


x = 1 NULL 1;
y = NULL 1 1;
(isNull x) || (isNull y);
// output: [1,1,0]
isNull x || isNull y;
// output: [0,1,0]
// equivalent to isNull (x || (isNull y))
```

Primitive unary operators, neg \(-\) and not \(!\), are two exceptions of the aforementioned unary operator rule. They are executed in the order of the precedence set in the operator table when mixed with other binary operators.

For example, -n..n is equivalent to \(-n\)..n because operator neg has higher priority than sequence.

```
n=5;
-n..n;
// output: [-5,-4,-3,-2,-1,0,1,2,3,4,5]

(-n)..n;
// output: [-5,-4,-3,-2,-1,0,1,2,3,4,5]

-(n..n);
// output: [-5]

x=1 2 3;
!x-1;
// output: [-1,-1,-1]
```

User defined functions have the same priority as \* and \\.

```
def f1(x,y):x+y
2 add 3 sub 5 f1 5;
// output: -5
```

**Parent topic:**[Operators](../../Programming/Operators/Operators.md)

## Integer overflow/underflow: {#integer-overflowunderflow}

As the default data type of integers in DolphinDB is INT with a range of -231+1 ~ 231-1, any arithmetic operation on INT with either intermediate or final result outside this range will cause integer overflow or underflow. If such a condition occurs, no warning or exception is raised and the result could be wrong numbers or null values, just as in C++ or Java. Therefore users should pay close attention to the possibilities of interger overflow/underflow. For example, when calculating standard deviations of integers on a huge table, we need to check if the result makes sense. To avoid integer overflow/underflow problem, we can change the data type of integer columns to be LONG.

```
100000*100000;
// output: 1410065408

>100000l*100000l;
10000000000
```

