# Operator Summary {#operator-summary}

|Name|Operator|Example|Precedence|Parties|Operand|
|----|--------|-------|----------|-------|-------|
|or|\|\||1\|\|0; \[2,3\]\|\| \[4,5\]; 0\|\|\[4,5\]|1|binary|A, V, S, M|
|and|&amp;&amp;|1&amp;&amp;0; \[2,3\]&amp;&amp;\[4,5\];|2|binary|A, V, S, M|
|lt|&lt;|1&lt;2; \[2,3\]&lt;\[4,5\]; 2&lt;\[4,5\]; 2&lt;4 5|3|binary|A, V, S, M|
|le|&lt;=|1&lt;=2; \[2,3\]&lt;=\[4,5\]; 2&lt;=\[4,5\]; 2&lt;4 5|3|binary|A, V, S, M|
|equal|==|1==2; \[2,3\]==\[4,5\];2==4 5|3|binary|A, V, S, M|
|gt|&gt;|1&gt;2; \[2,3\]&gt;\[4,5\]; 2&gt;4 5|3|binary|A, V, S, M|
|ge|&gt;=|2&gt;=1; \[2,3\]&gt;=\[4,5\]; 2&gt;=4 5|3|binary|A, V, S, M|
|ne|!= or &lt;&gt;|1!=2; \[2,3\]!=\[2,5\]; 2!=4 5; 2&lt;&gt;5|3|binary|A, V, S, M|
|bitOr \(union\)|\||0 \| 1|4|binary|A, V, S, M|
|bitXor|^|0 \| 1|5|binary|A, V, S, M|
|bitAnd \(intersection\)|&amp;|0 &amp; 1|6|binary|A, V, S, M|
|lshift|&lt;&lt;|1&lt;&lt;2|7|binary|A, V, M|
|rshift|&gt;&gt;|10&gt;&gt;2|7|binary|A, V, M|
|add|+|1+2; \[1,2\]+\[3,4\]|8|binary|A, V, S, M|
|sub|-|1-2; \[3,4\]-\[1,2\]; 5-\[3,4\]|8|binary|A, V, S, M|
|mul|\*|2\*3; \[1,2\]\*\[3,4\]; 3\*\[4,5,6\]|10|binary|A, V, S, M|
|dot|\*\*|\[1,2\]\*\*\[3,4\]|10|binary|V, M|
|div|/|2/3; 2.0/3; \[2,3,4\]/2|10|binary|A, V, M|
|ratio|\\|1\\2; \[2,3,4\]\\2|10|binary|A, V, M|
|mod|%|1%2; \[2,3,4\]%2|10|binary|A, V, M|
|cast|$|1..8$4:2; cast\(1..8, 4:2\); cast\(1.1,\`int\)|10|binary|A, V, M|
|join|&lt;-|1 2 3 &lt;- 4|10|binary|A, V, M, T|
|pair|:|1:3;|15|binary|A|
|seq|..|5..9, 9..5;|15|binary|A|
|not|!|!0; ! 3 4 0|18|unary|A, V, M|
|neg|-|-x; - 4 5 6;|18|unary|A, V, M|
|at|\[\]|x\[0\], x\[3 5 6\], x\[2,3\], x\[1:2,4:3\]|20|binary|V, M, T, D|
|member|.|x.price, d.2|20|binary|T, D|
|function operator|\(\)|x\(1, 2\)|20|binary|A, V|
|ternary operator|? :|\(1+1&gt;2\)?1:0|25|ternary|A, V, S, M, D, T|

**Note**: In the column of operand, the symbols A, V, S, M, D, T denote scalar, vector, set, matrix, dictionary and table respectively.

**Parent topic:**[Operators](../../Programming/Operators/Operators.md)

## Operator Syntax {#operator-syntax}

An operator connects operands in an expression. We choose commonly used symbols to represent the variety of operations. To make it easy to remember the operators, we give a name to each operator. You can use the name of the operator instead of the symbol in any expression. Let's take the operator "+" as an example.

```
x=1;
y=2;

// function as an operator

x+y;
// output: 3


x add y;
// output: 3

add(x,y);
// output: 3


x.add(y);
// output: 3
```

A user defined function can also be used as an operator. This function must have immutable parameters.

```
def f(a, b){return a*a + b*b - 2*a*b};
3 f 4;
// output: 1
```

