# not\(!\) {#not}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

!\(X\)

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

## Details {#details}

Return the NOT of *X*. Returned values are 0, 1, or NULL. The NOT of 0 is 1; the NOT of null is still NULL; the NOT of all other values is 0.

## Examples {#examples}

```
!1.5;
// output: 0

not 0;
// output: 1

x=1 0 2;
not x;
// output: [0,1,0]

m=1 1 1 1 1 0 0 0 0 0$2:5;
m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|1|1|0|0|
|1|1|0|0|0|

```
not m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|0|0|0|1|1|
|0|0|1|1|1|

```
(1).not();
// output: 0

(!NULL)==NULL;
// output: 1
```

You can precede a predicate with the NOT keyword to specify the opposite of the predicate's value. For example, `not in`, `not between`, `not exists`.

```
t = table(`a`a`b`c`b as sym, 3.1 2.2 3.3 2.8 3.0 as val)
select * from t where sym not in `a`c
```

|sym|val|
|---|---|
|b|3.3|
|b|3|

Related functions: [and](../../../Functions/a/and.md), [or](or.md)

