# ne\(!=\) {#ne}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X != Y

or

X &lt;&gt; Y

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix/set. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

If neither *X* nor *Y* is a set, conduct the element-by-element comparison of *X* and *Y*; return 1 if the elements in*X* and *Y* are not the same.

If *X*and *Y* are sets, check if *X* and *Y* are not identical.

## Examples {#examples}

```
1 2 3 != 2;
// output: [1,0,1]

1 2 3 ne 0 2 4;
// output: [1,0,1]

1:2 != 1:6;
// output: 0 : 1

m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
t = table(`A`B`M`B`A`M as sym, 10.1 11.2 11.3 12 10.6 10.8 as val)
select * from t where nullIf(sym, `M)<>NULL

/* output
sym   val
A     10.1
B     11.2
B     12
A     10.6
*/
```

```
m1 != 4;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|0|1|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1 ne m2;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|1|1|

Set operation: If X!=Y then X and Y are not identical

```
x=set(4 6);
y=set(4 6 8);

x!=y;
// output: 1
x!=x;
// output: 0
```

