# mod\(%\) {#mod}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X % Y

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

*mod* means modulus. It returns the element-by-element remainder of *X* divided by *Y*. When *Y* is a positive integer, the modulus is always non-negative, e.g., -10 % 3 is 2. When *Y* is a negative integer, the modulus is always non-positive, e.g., -10 % -3 is -1.

Function [mod](../../../Functions/m/mod.md) is often used to group data. For example, \[5,4,3,3,5,6\]%3 is \[2,1,0,0,2,0\]; data can thereby be divided into three groups.

## Examples {#examples}

```
x=1 2 3;
x % 2;
// output: [1,0,1]

2 % x;
// output: [0,0,2]

y=4 5 6;
x mod y;
// output: [1,2,3]
mod(y, x);
// output: [0,1,0]

m=1..6$2:3;
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m mod 3;
```

|\#0|\#1|\#2|
|---|---|---|
|1|0|2|
|2|1|0|

```
x=-1 2 3;
x%-5;
// output: [-1,-3,-2]

-1%5;
// output: 4
```

