# eachAt\(@\) {#eachat}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X@index

eachAt\(X, index\)

## Arguments {#arguments}

**X** can be a scalar/vector\(including tupleand array vector\)/matrix/table/dictionary/pair/unary function.

**index** can be a Boolean expression/scalar/vector/tuple/array vector/pair.

## Details {#details}

If *index* is a Boolean expression, returns the elements in *X* that satisfy the condition specified by *index* \(i.e., *index* = true\). If not, returns the elements in *X* with the corresponding *index*.

If *X* is a function, *index* is used as an argument of *X*.

The differences between `eachAt` and `at` lie in:

\(1\) when *index* is a tuple \(e.g., *index* = \(0, 1\) \), and *X* is a tuple of vectors:

-   `X @ (0, 1)` returns the first and second elements in *X*.

-   `X at (0, 1)` returns the value at position 1 of the first element in *X*.


\(2\) when *X* is a function:

-   Only unary function can be specified for `eachAt`.

-   Function with one or multiple parameters can be specified for `at`.


The following table shows the data forms supported by *X* and *index*.

|X/index|Boolean expression|scalar|vector|tuple|pair|
|-------|------------------|------|------|-----|----|
|scalar|√|√|√|√|√|
|vector|√|√|√|√|√|
|tuple|√|√|√|√|√|
|matrix|√|√|√|√|√|
|table|√|√|√|√|√|
|dictionary|×|√|√|√|×|
|pair|√|√|√|√|√|
|function|√|√|√|√|√|

|X/index|Boolean expression|scalar|vector|array vector|tuple|pair|
|-------|------------------|------|------|------------|-----|----|
|scalar|√|√|√|×|√|√|
|vector|√|√|√|√|√|√|
|tuple|√|√|√|×|√|√|
|array vector|√|√|√|×|√|√|
|matrix|√|√|√|×|√|√|
|table|√|√|√|×|√|√|
|dictionary|×|√|√|×|√|×|
|pair|√|√|√|×|√|√|
|function|√|√|√|√|√|√|

## Examples {#examples}

```
v = 3.1 2.2 4.5 5.9 7.1 2.9
eachAt(v, v > 3)
// output: [3.1,4.5,5.9,7.1]
    
v @ 1:3
// output: [2.2,4.5]

v @ (:4)
// output: [3.1,2.2,4.5,5.9]
v @ (3:)
// output: [5.9,7.1,2.9]

// the difference between eachAt and at when index is specified as a tuple
tp = [2.3 2.1 2.2, 3.1 2.9 2.8, 5.7 6.9]
tp @ [1 2 3, 0 1 2]
// output: (([3.1,2.9,2.8],[5.7,6.9],),([2.3,2.1,2.2],[3.1,2.9,2.8],[5.7,6.9]))
tp at [1 2 3, 0 1 2]
// output: ([3.1,2.9,2.8],[5.7,6.9,],)

sum @ 6 2 3 NULL 2 -3
// output: 10

// seq(...) must be enclosed in parentheses since its priority is lower than @
sum @ (1..10)
// output: 55
```

Related functions: [at](at.md)

