# dot\(\*\*\) {#dot}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X \*\* Y

## Arguments {#arguments}

**X** and **Y** is a scalar/vector/matrix. If both of *X* and *Y* are vectors, they must have the same length. If one of *X*/*Y* is a matrix and the other is a vector/matrix, their dimensions must satisfy the rules of matrix multiplication.

## Details {#details}

Return the matrix multiplication of *X* and *Y*. If *X* and *Y* are vectors of the same length, return their inner product.

## Examples {#examples}

```
x=1..6$2:3;
y=1 2 3;
x dot y;
```

|\#0|
|---|
|22|
|28|

```
x=1..6$2:3;
y=6..1$3:2;
x**y;
```

|\#0|\#1|
|---|---|
|41|14|
|56|20|

```
y**x;
```

|\#0|\#1|\#2|
|---|---|---|
|12|30|48|
|9|23|37|
|6|16|26|

```
z=1 2 3;
shape z;
// output: 3:1
x**z;
// matrix and vector multiplication
```

|\#0|
|---|
|22|
|28|

```
x=1 2 3;
y=4 5 6;
x ** y;
// output: 32
// inner product of two vectors. Equivalent to 1*4 + 2*5 + 3*6

x ** 2;
// output: [2,4,6]

x=1..6$2:3
x ** 2;
Use * rather than ** for scalar and matrix multiplication.
```

