# add\(+\) {#add}

**Parent topic:**[Operators](../../../Programming/Operators/Operators.md)

## Syntax {#syntax}

X + Y

## Arguments {#arguments}

**X** and **Y** is a scalar/pair/vector/matrix. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return the element-by-element sum of *X* and *Y*.

## Examples {#examples}

```
3 add 2;
// output: 5

1:2+6;
// output: 7 : 8

1:2+3:4;
// output: 4 : 6

3+1..3;
// output: [4,5,6]

add(1..3, 4..6);
// output: [5,7,9]

(1..3).add(4..6);
// output: [5,7,9]

x=reshape(1..6, 3:2);
x;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
x+1.5;
```

|\#0|\#1|
|---|---|
|2.5|5.5|
|3.5|6.5|
|4.5|7.5|

```
y=reshape(5..10, 3:2);
y;
```

|\#0|\#1|
|---|---|
|5|8|
|6|9|
|7|10|

```
x+y;
```

|\#0|\#1|
|---|---|
|6|12|
|8|14|
|10|16|

