# Undefine Variables {#undefine-variables}

Sometimes, we need to undefine a variable or a function definition so that it can be used for other purposes, or to save memory.

## Syntax {#syntax}

undef\(obj, \[objType=VAR\]\)

or

undef all

## Arguments {#arguments}

**obj** a string scalar/vector indicating the name\(s\) of the object\(s\) to be undefined.

**objType** the type of object\(s\) to be undefined. It can be one of the following: VAR, SHARED, or DEF

## Details {#details}

Delete variable or function definitions.

## Examples {#examples}

```
undef all;

x=1
undef(`x, VAR);

x=1
y=2
undef(`x`y, VAR);

def f(a){return a+1}
undef(`f, DEF);
```

The [undef](../../../Functions/u/undef.md) command will release a variable in runtime, not in parsing stage.

