# Utility Functions {#UtilityFunctions}

## Metaprogramming {#Metaprogramming .section}

DolphinDB supports generating metacode for method calls defined within classes using the following functions:

-   `objCall(obj, methodName, args...)`

-   `unifiedObjCall(obj, methodName, args)`

-   `makeObjCall(obj, methodName, args...)`

-   `makeUnifiedObjCall(obj, methodName, args)`


where

-   *obj* is the object.

-   *methodName*is a string representing the method name.

-   *args...* are the parameters passed to the method.


**Examples**

Use `makeObjCall` to create metacode for OOP method calls:

``` {#codeblock_prr_zxt_4bc}
class Person {
  name :: STRING
  age :: INT
  def Person(name_, age_) { 
    name = name_
    age = age_
  }
  def setName(newName) {
    name = newName
  }
  def getName(year, gender) {
    if (year < 2020)
      return year
    else
      return name
  }
}
a = Person("Harrison", 20)
f = a.getName{2015}
f(true)
// Use objCall
objCall(a, "getName", 2015, true)
// Use unifiedObjCall
unifiedObjCall(a, "getName", (2015, true))
// Use makeObjCall
makeObjCall(a, "getName", 2015, true).eval()
// Use makeUnifiedObjCall
makeUnifiedObjCall(a, "getName", (2015, true)).eval()
```

## Other Functions {#Other-Functions .section}

-   `isInstanceOf(obj, cls)`: Checks if an object is an instance of a specific class or its derived class, returning a Boolean value.

    ``` {#codeblock_cfd_1yt_4bc}
    class B {
      def B() {}
    }
    class D : B {
      def D() {}
    }
    class A {
      def A() {}
    }
    d = D()
    isInstanceOf(d, D)  // true
    isInstanceOf(d, B)  // true
    isInstanceOf(d, A)  // false
    ```

-   `setAttr(obj, attrName, value)`: Sets or modifies the attributes of an object *obj*. For example, `setAttr(obj, `alpha, 16)`, or `obj.setAttr(`alpha, 16)`.


These utility functions enable flexible and dynamic manipulation of class instances and their methods, enhancing the power of object-oriented programming in DolphinDB.

**Parent topic:**[Object-Oriented Programming](../../Programming/OOP/ObjectOrientedProgramming.md)

