# Member Methods {#Method}

## Defining a Member Method {#Defining-a-Member-Method .section}

Methods are functions defined within a class to manipulate the data of class objects. Member methods can access class member variables and provide an interface for operations on objects.

For example, the `setName(newName)` method is defined in class `Person`.

``` {#codeblock_dsw_jxt_4bc}
def setName(newName) {
    name = newName
}
```

## Separating Declarations and Definitions {#Declaring-and-Defining-Variables .section}

DolphinDB classes allow declaring a function or variable and then defining it separately. Before calling a method, it must be at least declared in the code. Additionally, member variables must be declared before methods.

``` {#codeblock_yvq_kxt_4bc}
class Test1 {
    def Test1() {}
    // Declare b1 method without definition
    def b1()
    def a1() {
        // Define a1 function which calls b1
        b1()
    }
    // Define b1
    def b1() {
        print("test")
    }
}
```

The following example demonstrates the parsing order of variables when used within a member method.

``` {#codeblock_uxf_lxt_4bc}
share table(1:0, `sym`val, [SYMBOL, INT]) as tbl
go
class Test2 {
    a :: INT
    b :: DOUBLE
    def Test2() {
        a = 1
        b = 2.0
    }
    def method(b) {
        print(b) // parsed as method parameter b
        print(a) // parsed as object attribute a
        print(tbl) // parsed as shared variable tbl
        print(qwert) // Error: Variable does not exist
    }
}
```

1.  **Method Parameters**: When referencing a variable within a method, the system first checks if the variable name matches any of the method's parameters. In the example, within the `method`, the variable *b* is referenced, and it matches the parameter name, so *b* is parsed as the method parameter.

2.  **Attributes**: If there is no matching method parameter, the system checks if the variable is an attribute of the object. In the example, the variable *a* is not defined within the method, so it checks the object's attributes and parsed *a* as an attribute.

3.  **Shared Variables**: If the variable does not match either a method parameter or an attribute, the system checks if it is a shared variable defined outside the class.

4.  **Non-existence**: If the variable is not found through the above three steps, an error is raised indicating that the variable does not exist.


This parsing order ensures that when using variables within member methods, the closest scope is considered first, following a logical progression from method parameters to attributes and then to shared variables.

## `self` {#self .section}

The `self` variable is used to reference the instance of the class, which is similar to the `self` in Python or the `this` pointer in Java and C++. For the following example, the method `testSelf()` prints the instance of the class `Volume`.

``` {#codeblock_ubk_qxt_4bc}
class Volume{
	a :: INT
	b :: INT
	def Volume() {
		a = 1
		b = 2
	}
	def testSelf() {
		print(self)
	}
}

a = Volume()
a.testSelf()
```

**Note:** Currently DolphinDB classes do not support the following operations:

-   Modifying object attribute values through `self`, e.g., `self.attribute = newValue`.

-   Directly setting object attributes using `obj.name = newValue`. Instead, please use the `setAttr` function to set attributes.


## Partial Application {#Partial-Application .section}

Partial application is an important feature in DolphinDB. Methods in classes can be called using partial application by fixing some parameters with `{}`. For more information, see [Partial Application](../FunctionalProgramming/PartialApplication.md).

## Special Member Methods {#Special-Member-Methods .section}

-   `str()`: When the `str()` method is defined, using the `print()` function to print the object will output the result of the `str()` method.

-   `repr()`: Using the `print()` function to print the object will output the result of the `repr()` method.


If these methods are not defined in the class, printing the object will return `<Instance of Class 'ClassName'>`.

**Parent topic:**[Object-Oriented Programming](../../Programming/OOP/ObjectOrientedProgramming.md)

