# Closure {#closure}

A closure is a function object that remembers values in enclosing scopes regardless of whether those scopes are still present in memory.

When a lambda expression is defined within another function, it automatically has access to the parent function.

```
g=def(a){return def(b): a pow b};
g(10)(5);
// output: 100000

def mixture(a,b){return def(c): c*(a-b)+(1-c)*(a+b)};
g=mixture(10,5);
g(0.1);
// output: 14

def f(a,b){return def(x): a*x+b*(1-x)};
f(5,10)(0.2);
// output: 9
```

**Parent topic:**[Functional Programming](../../Programming/FunctionalProgramming/FunctionalProgramming.md)

