# tensor {#tensor}

A tensor is an essential structure used in deep learning and machine learning, primarily representing multi-dimensional data. To better integrate with deep learning frameworks like PyTorch, DolphinDB has introduced the tensor data structure. A tensor is essentially a multi-dimensional array, stored in a row-major format \(i.e., elements are contiguously arranged by rows in memory\).

A tensor has two important attributes: shape and strides. Shape is a vector that describes the size of each dimension of the tensor, and shape\[i\] represents the size of the \(i+1\)th dimension \(as index 0 usually indicates the first dimension\). Strides is a vector of the same length as shape, indicating the number of elements to skip in memory to get to the next element along each dimension of the tensor. DolphinDB tensor data is contiguously stored, so strides can be calculated from the shape. For example, for a 3-dimensional tensor, if shape=\[D, H, W\], then strides would be \[H\*W, W, 1\].

Currently in DolphinDB, tensors are generated using the tensor function and are mainly used in the plugins \(such as [LibTorch](../../../Plugins/libtorch.md)\) for data exchange with deep learning frameworks. For information on how to generate a tensor, please refer to [tensor](../../../Functions/t/tensor.md).

Note: DolphinDB does not currently support direct storage and computation of tensors, nor direct access or modification to their elements.

**Parent topic:**[Data Forms](../../../Programming/DataTypesandStructures/DataForms/DataForms.md)

