# Scalar {#scalar}

A scalar is an atomic variable or constant holding one value at a time. In contrast, all other data forms can hold more than one objects.

```
1b;
// a boolean scalar

true;
// a boolean scalar

5;
// an int scalar

119c;
// a char scalar

1.2f;
// a float scalar

20987.58F;
// a double scalar

`Hello;
// a string scalar

2013.06.13;
// a date scalar

2012.12M
// a month scala

2016.10.12T00:00:00.001
// a timestamp scalar

12:32:56.356
// a time scalar

x=5;
form x;
// output: 0
// 0 indicates that x is a scalar variable
```

**Parent topic:**[Data Forms](../../../Programming/DataTypesandStructures/DataForms/DataForms.md)

## Computation on scalars {#computation-on-scalars}

-   Binary operations on 2 scalars: the result is a scalar.

```
add(1,2)
// output: 3
```

-   Binary operations between a scalar and a vector: the result is a vector.

```
mul(1 2 3, 3);
// output: [3,6,9]
```

