# Pair {#pair}

In contrast to a scalar, a pair holds 2 values at a time. The two values need to be of the same data type. Pair is a special vector with two values.

A data pair can be used to:

\(1\) Represent data range.

In the following scenarios, the data range does not include the upper bound:

-   The pair represents offsets within an array/matrix/table.


``` {#codeblock_prd_ym3_5yb .python}
x=5 3 6 2;
x[1:3];
// output: [3,6]

for(s in 1:3){print s};
/* output
1
2
*/

[5,6,8] between 1:6;
// output: [1,1,0]
```

-   Used in a for-loop.


``` {#codeblock_rrd_ym3_5yb .python}
for(s in 1:3){print s};
/* output
1
2 
*/
```

-   Used in function [bucket](../../../Functions/b/bucket.md) or [bucketCount](../../../Functions/b/bucketCount.md):


``` {#codeblock_trd_ym3_5yb .python}
bucket(4 0 1 3 2, 0:4, 2);
// output: [,0,0,1,1]
```

In all other scenarios, the range includes the upper bound.

``` {#codeblock_urd_ym3_5yb .python}
[5,6,8] between 1:6;
// output: [1,1,0]

t1 = table(`A`A`B as sym, 09:56:06 09:56:07 09:56:06 as time, 10.6 10.7 20.6 as price)
t2 = table(take(`A,10) join take(`B,10) as sym, take(09:56:00+1..10,20) as time, (10+(1..10)\10-0.05) join (20+(1..10)\10-0.05) as bid, (10+(1..10)\10+0.05) join (20+(1..10)\10+0.05) as offer, take(100 300 800 200 600, 20) as volume)
wj(t1, t2, -5:0, <avg(bid)>, `sym`time);
```

\(2\) Illustrate the dimension of a matrix. e.g. "2:5" indicates a 2 by 5 matrix. If X is a one dimension array with 10 elements, statement "X$2:5" converts X to a 2 by 5 matrix, where "$" indicates conversion.

\(3\) Specify the capacity and initial number of rows of a table.

``` {#codeblock_vrd_ym3_5yb .python}
t=table(100:0, `date`sym`high`low`close, [DATE,SYMBOL,DOUBLE,DOUBLE,DOUBLE]);
```

**Parent topic:**[Data Forms](../../../Programming/DataTypesandStructures/DataForms/DataForms.md)

## Create Pairs {#create-pairs}

To create a pair, we use symbol colon ":" or function [pair](../../../Functions/p/pair.md).

```
1:3;

3.4:7.8;

1b:0b;
// output: 1:0
true:false;
// output: 1:0

2013.06.13:2013.11.10;

5 pair 6;
// output: 5:6

`Hello:`World;
// output: "Hello" : "World"
```

## Access Pairs {#access-pairs}

Use X\[Y\] to access pairs, where Y can be an integer, an integer vector or a pair.

```
x = 3:6;

x[1];
// output: 6

x[0 1];
// output: [3,6]
```

## Modify Pairs {#modify-pairs}

```
x=3:6;

x[0]=4;
x;
// output: 4:6

x=3:6+1;
x;
// output: 4 : 7
// note the result is not 3:7
```

