# columnar tuple {#columnar-tuple}

The columnar tuple is a special type of tuple, whose elements can be either scalars or vectors with the same data type. Data retrieval from a columnar tuple is in the same way as that from an array vector.

Starting from version 2.00.9, DolphinDB supports storing a columnar tuple as a column of a table \(DFS tables are not supported yet\).

**Creating a columnar tuple**

To convert a regular tuple into a columnar tuple, you can use function [setColumnarTuple!](../../../../Functions/s/setColumnarTuple!.md).

To check whether a tuple is a columnar tuple, you can use function [isColumnarTuple](../../../../Functions/i/isColumnarTuple.md).

```


    tp = [[1.3,2.5,2.3], [4.1,5.3], 6.3]
    isColumnarTuple(tp)
    false

    tp.setColumnarTuple!()
    isColumnarTuple(tp)
    true
```

**Retrieving data from a columnar tuple**

If you retrieve data from a regular tuple, the element with the specified index is returned. For columnar tuples or array vectors, a vector of values with the specified index taken from each element is returned.

```


    tp = [[1.3,2.5,2.3], [4.1,5.3], 6.3]
    ctp = [[1.3,2.5,2.3], [4.1,5.3], 6.3].setColumnarTuple!()
    av = array(DOUBLE[], 0, 20).append!([[1.3,2.5,2.3], [4.1,5.3], 6.3])

    // accessing by index
    tp[0]
    [1.3,2.5,2.3]

    ctp[0]
    [1.3,4.1,6.3]

    av[0]
    [1.3,4.1,6.3]
```

When you retrieve data from a columnar tuple by slicing \(i.e., x\[start:end\]\), if the range exceeds the length of its element, the null values will be automatically filled.

When the elements are not of STRING or SYMBOL type, and the end index of the slicing is specified, it returns an array vector, otherwise it returns a columnar tuple.

```


    //accessing by slicing
    a = ctp[0:3]
    a
    [[1.3,2.5,2.3],[4.1,5.3,00F],[6.3,6.3,6.3]]

    b = ctp[0:]
    b
    ([1.3,2.5,2.3],[4.1,5.3],6.3)
```

You can use the `row` function to retrieve rows from a columar tuple.

```


    ctp.row(0)
    [1.3,2.5,2.3]
```

**Appending data to a columnar tuple**

```


    ctp = [[1.3,2.5,2.3], [4.1,5.3], 6.3].setColumnarTuple!()
    ctp.append!([3.3,2.1])
    ctp
    ([1.3,2.5,2.3],[4.1,5.3],6.3,[3.3,2.1])
```

**Modifying Data from a Columnar Tuple**

Specific elements in columnar tuples can be modified by referring to their row and column indices: `obj[rowIndex, colIndex] = newValue`.

**rowIndex**\(optional\) is a scalar or pair. If it is a pair and the lower bound is not specified, the range starts from the first row; if the upper bound is not specified, the range ends at the last row. If *rowIndex* is not specified, all rows of data will be modified.

**colIndex** is a scalar or pair. If it is a pair, its lower and upper bounds must be specified.

**newValue** is a scalar, vector, or pair:

-   If *newValue* is a scalar, all data specified by *rowIndex* and *colIndex* will be modified to *newValue*;

-   If *newValue* is a vector or tuple with the same length as *colIndex*, the data specified by *colIndex* in each row will be modified to *newValue*;

-   If *newValue* is a vector or tuple with the same length as *rowIndex* and contains elements that are scalars or vectors matching the length of *colIndex*, the data in each row will be modified to the corresponding element in *newValue*.


``` {#codeblock_nky_l2f_m1c}
// Create a columnar tuple ctp
ctp = [1 2 3 4, 5 6 7 8 , 9 10 11 12].setColumnarTuple!()
print ctp 
// ([1,2,3,4],[5,6,7,8],[9,10,11,12])

// Modify the data in the first row and second column to 50
ctp[0,1] = 50
print ctp 
// ([1,50,3,4],[5,6,7,8],[9,10,11,12])

// Modify the data in the first to second rows and second to third columns to 100 200
ctp[0:2, 1:3] = 100 200
print ctp
// ([1,100,200,4],[5,100,200,8],[9,10,11,12])

// Modify the data in the first to second rows and second to third columns to 300 400, with the lower bound of colIndex unspecified
ctp[:2, 1:3] = 300 400
print ctp
// ([1,300,400,4],[5,300,400,8],[9,10,11,12])

// Modify the data in the second to third columns of the first row to 500 600, and that of the second row to 700 800
ctp[0:2, 1:3] = (500 600, 700 800)
print ctp
// ([1,500,600,4],[5,700,800,8],[9,10,11,12])

// Modify the data in the second to third columns of all rows to 900 1000
ctp[, 1:3] = 900 1000
print ctp
// ([1,900,1000,4],[5,900,1000,8],[9,900,1000,12])
```

**Calculating columnar tuples by row**

```


    ctp = [[1.3,2.5,2.3], [4.1,5.3], 6.3].setColumnarTuple!()
    rowSum(ctp)
    [6.1,9.4,6.3]
```

**Creating an in-memory table with a columnar tuple**

Regular tuples with elements of unequal length are stored as columnar tuples in a DolphinDB in-memory table.

```


    sym = `st1`st2`st3
    price = [[3.1,2.5,2.8], [3.1,3.3], [3.2,2.9,3.3]]
    t = table(sym, price)
    t;

    sym price        
    --- -------------
    st1 [3.1,2.5,2.8]
    st2 [3.1,3.3]    
    st3 [3.2,2.9,3.3]
```

Note: For tuples with elements of equal length, to store each element by row, you can first convert them to columnar tuples with the `setColumnarTuple!` function.

```


    id = 1 2 3
    val = [[1,2,3], [4,5,6],[7,8,9]]
    table(id, val)
    id	col1	col2	col3
    1	1	4	7
    2	2	5	8
    3	3	6	9

    table(id, val.setColumnarTuple!())
    id val    
    -- -------
    1  [1,2,3]
    2  [4,5,6]
    3  [7,8,9]
```

**Parent topic:**[Vector](../../../../Programming/DataTypesandStructures/DataForms/Vector/vector.md)

