# Tuple \(ANY Vector\) {#tuple-any-vector}

Vectors can be divided into tuples and typed vectors based on the data type of elements. Elements in typed vectors must be scalars with the same data type, whereas elements in tuples can be scalars or vectors with flexible data types. Therefore, the data type of tuples in DolphineDB is defined as ANY.

Tuples are always displayed with round brackets, for instance, "\(1, 2, 3\)". When creating a typed vector with square brackets, if it contains vectors or elements of multiple data types, it will be converted to a tuple, for example, "\[1, 'A'\]", "\[\[1,2,3\], \[4,5\]\]".

As we will see later in this chapter, however, it is possible to use square brackets to construct tuples.

**Parent topic:**[Vector](../../../../Programming/DataTypesandStructures/DataForms/Vector/vector.md)

## Creating a tuple {#creating-a-tuple}

\(1\) Comma-separated elements in round brackets. This always generates a tuple, no matter whether the elements are of the same type or not. It allows for line breaks before or after commas.

```
a=(1 2 3, `IBM`MSFT`GOOG, 2.5);
a;
// output: ([1,2,3],["IBM","MSFT","GOOG"],2.5)

// define a tuple across multiple lines
a=(1 2 3, 
`IBM`MSFT`GOOG, 2.5);
a;
// output: ([1,2,3],["IBM","MSFT","GOOG"],2.5)

a=(1, 2, 3);
typestr a;
// output: ANY VECTOR

x=(1..10, `GOOG);
x;
// output: ([1,2,3,4,5,6,7,8,9,10],"GOOG")

x=1..10;
y=rand(100,10);
a=(x+y,x-y);
a;
// output: ([73,26,32,96,26,86,11,63,21,49],[-71,-22,-26,-88,-16,-74,3,-47,-3,-29])
```

We can use \(\) to create an empty tuple.

```
x=();
x.append!(1..3);
// output: ([1,2,3])
x.append!(`GS);
// output: ([1,2,3],"GS")

x=(1,2,3);
x;
// output: (1,2,3)
x.append!(`GS);
// output: (1,2,3,"GS")
```

We cannot transform a typed vector to a tuple with the [append!](../../../../Functions/a/append!.md) function.

```
x=1 2 3;
x;
// output: [1,2,3]
x.append!(`GS);
// output: Incompatible type. Expected: INT, Actual: STRING
```

\(2\) space separated elements with different data types, or comma-separated elements of different data types in square brackets "\[\]". Square brackets always attempt to create a typed vector first. If it fails, it will create a tuple instead.

```
a = 3 2012.02.03 `GOOG;
// output: (3,2012.02.03,"GOOG")
typestr a;
// output: ANY VECTOR

a=[[1,2,3,4,5,6,7,8,9,10],2,[`IBM, `MSFT,`GOOG]];
a;
// output: ([1,2,3,4,5,6,7,8,9,10],2,["IBM","MSFT","GOOG"])

x=1..10;
y=rand(100,10);
b=[x+y,x-y];
b;
// output: ([73,26,32,96,26,86,11,63,21,49],[-71,-22,-26,-88,-16,-74,3,-47,-3,-29])
```

\(3\) use function [array](../../../../Functions/a/array.md) with "any" as the first element and then specify individual elements:

```
a=array(any, 3); a[0]=1..10; a[1]=2; a[2]=`IBM`MSFT`GOOG;
a;
// output: ([1,2,3,4,5,6,7,8,9,10],2,["IBM","MSFT","GOOG"])
```

## Accessing tuples {#accessing-tuples}

```
x=(1 2 3 4 5 6 7 8 9 10,(5 7 8, 11 3 5));
x;
// output: ([1,2,3,4,5,6,7,8,9,10],([5,7,8],[11,3,5]))

x[1];
// output: ([5,7,8],[11,3,5])

x[1,1];
// output: [11,3,5]

x[1,1,1];
// output: 3

x[0 1];
// output: ([1,2,3,4,5,6,7,8,9,10],([5,7,8],[11,3,5]))

x[0 1,1];
// output: (2,[11,3,5])

x[, 1];
// output: (2,[11,3,5])

x[1, ,0 2];
// output: ([5,8],[11,5])

x[,1,1];
// output: (2,3)

x[1 2];
// output: (([5,7,8],[11,3,5]),)
```

## Modifying tuples {#modifying-tuples}

We can append a tuple with new elements. We can also assign a new object to a particular element.

-   Append an element to a tuple.


```
x=`C 120`BH 100;
x;
// output: ("C",120,"BH",100)

x.append!("AAPL");
// output: ("C",120,"BH",100,"AAPL")

x.append!(300);
// output: ("C",120,"BH",100,"AAPL",300)

x.append!(`IBM 600);
// output: ("C",120,"BH",100,"AAPL",300,("IBM",600))
```

-   Modify an element of a tuple by assigning the new value to an object:


```
tp = [["aaa", "bbb"], "ccc"]
tp[0] = tp[0].replace(tp[0][1], "A")
tp
// output: (["aaa","A"],["ccc"])
```

## Computation on tuples {#computation-on-tuples}

Tuples are designed to hold mixed data types, not for efficient computation. However, computations are still allowed on tuples if the elements are numbers.

Functions supporting tuples include scalar functions, vector functions \(regular and cum/m functions\), and aggregate functions.

For vector functions, the dictionary can be processed either row by row or column by column, controlled by the *processVectorFunctionOverTupleByRow* parameter:

-   true \(default\): row-wise. Elements at the same position across all keys are combined into a row, and the function is applied row by row.
-   false: column-wise. Each value vector is treated as a column, and the function is applied separately to each column.

```
a=(2, [3, 5], 10);

max a;
// output: [10,10]

prod a;
// output: [60,100]

cumsum a;
// output: (2,[5,7],[15,17])
```

We can apply logic or relationship operators to tuples.

```
a=(2, [3, 5], 10);

a>3;
// output: (0,[0,1],1)

a==2;
// output: (1,[0,0],0)

isNull a;
// output: (0,[0,0],0)
```

We can apply math operators such as [add](../../../../Functions/a/add.md), [sub](../../../../Functions/s/sub.md), [mul](../../../../Functions/m/mul.md), [div](../../../../Functions/d/div.md), [ratio](../../../../Functions/r/ratio.md), [mod](../../../../Functions/m/mod.md), [pow](../../../../Functions/p/pow.md) and [abs](../../../../Functions/a/abs.md) to tuples.

```
a=(2, [3, 5], 10);

a+2;
// output: (4,[5,7],12)

a pow 3;
// output: (8,[27,125],1000)
```

## Tuple for multiple assignments {#tuple-for-multiple-assignments}

```
x,y=(1 2 3, 2:5);
x;
// output: [1,2,3]
y;
// output: 2 : 5
```

## Tuple for a function returning more than one value {#tuple-for-a-function-returning-more-than-one-value}

```
def foo(a,b){return a+b, a-b};

x = foo(15,10);

x;
// output: (25,5)

typestr x;
// output: ANY VECTOR
```

