# Data Forms {#data-forms}

DolphinDB has the following data forms:

<table><thead><tr><th align="left">

Data Form Name

</th><th align="left">

Example

</th></tr></thead><tbody><tr><td align="left">

scalar

</td><td align="left">

5, 1.3, 2012.11.15, \`hello

</td></tr><tr><td align="left">

vector

</td><td align="left">

5 4 8 or \[5, 4, 8\], [array](../../../Functions/a/array.md), [BigArray](Vector/BigArray.md), [arrayVector](Vector/arrayVector.md)

</td></tr><tr><td align="left">

pair

</td><td align="left">

3:5; 'a':'c'; "Tom":"John", [pair](../../../Functions/p/pair.md)

</td></tr><tr><td align="left">

matrix

</td><td align="left">

1..6$2:3 or reshape\(1..6, 2:3\). matrix: [matrix](../../../Functions/m/matrix.md); indexed matrix: [setIndexedMatrix!](../../../Functions/s/setIndexedMatrix!.md); indexed series: [indexedSeries](../../../Functions/i/indexedSeries.md) / [setIndexedSeries!](../../../Functions/s/setIndexedSeries!.md)

</td></tr><tr><td align="left">

set

</td><td align="left">

[set](../../../Functions/s/set.md)

</td></tr><tr><td align="left">

dictionary

</td><td align="left">

[dict](../../../Functions/d/dict.md)

</td></tr><tr><td align="left">

table

</td><td align="left">

in-memory table: [table](../../../Functions/t/table.md); DFS table: [createPartitionedTable](../../../Functions/c/createPartitionedTable.md); indexed table: [indexedTable](../../../Functions/i/indexedTable.md); keyed table: [keyedTable](../../../Functions/k/keyedTable.md); stream table: [streamTable](../../../Functions/s/streamTable.md); high-availability stream table: [haStreamTable](../../../Functions/h/haStreamTable.md); mvcc table: [mvccTable](../../../Functions/m/mvccTable.md)

</td></tr><tr><td>

tensor

</td><td>

Use [tensor](../../../Functions/t/tensor.md) to create tensors with up to 10 dimensions.

 Note: Only the following data types are currently supported: BOOL, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE.

</td></tr></tbody>
</table>Use function [form](../../../Functions/f/form.md) to get the data form ID of a variable or constant.

```
form false;
// output: 0
form `TEST;
// output: 0

form `t1`t2`t3;
// output: 1
form 1 2 3;
// output: 1

x= 1 2 3
if(form(x) == VECTOR){y=1};
y;
// output: 1

form 1..6$2:3;
// output: 3

form(tensor(1..10$5:2))
// output: 10
```

