# Time Zone and Conversion {#time-zone-and-conversion}

Temporal objects in DolphinDB do not include time zone information. It is up to users to interpret the time zones of the temporal objects.

DolphinDB automatically detects the local time zones.

We can use the following functions to convert time between different time zones:

\(1\) [localtime](../../../Functions/l/localtime.md) convert time from GMT \(Greenwich Mean Time\) to local time zone.

\(2\) [gmtime](../../../Functions/g/gmtime.md) convert time from local time zone to GMT \(Greenwich Mean Time\).

\(3\) [convertTZ](../../../Functions/c/convertTZ.md) convert time between different time zones.

Time zone conversion functions address the daylight saving time automatically if either the source time zone or the destination time zone adopts the daylight saving time.

**Parent topic:**[Temporal Objects](../../../Programming/DataManipulation/TemporalObjects/TemporalObjects.md)

## Examples {#examples}

The following examples were conducted in US Eastern time zone.

```
localtime(2018.01.22T15:20:26);
// output: 2018.01.22T10:20:26

localtime(2017.12.16T18:30:10.001);
// output: 2017.12.16T13:30:10.001

gmtime(2018.01.22 10:20:26);
// output: 2018.01.22T15:20:26

gmtime(2017.12.16T13:30:10.008);
// output: 2017.12.16T18:30:10.008

convertTZ(2016.04.25T08:25:45,"US/Eastern","Asia/Shanghai");
// output: 2016.04.25T20:25:45


// with daylight saving time in US:
convertTZ(2016.04.25T19:25:45,"US/Eastern","Asia/Shanghai");
// output: 2016.04.26T07:25:45
```

