# Temporal Type and Conversion {#temporal-type-and-conversion}

Temporal variables in DolphinDB have the following data types:

|Data Type|Example|
|---------|-------|
|date|2013.06.13|
|month|2012.06M|
|time|13:30:10.008|
|minute|13:30m|
|second|13:30:10|
|datetime|2012.06.13 13:30:10 or 2012.06.13T13:30:10|
|timestamp|2012.06.13 13:30:10.008 or 2012.06.13T13:30:10.008|
|nanotime|09:00:01.000100001|
|nanotimestamp|2016.12.30T09:00:01.000100001|

We can use temporal functions to convert a temporal data type into another temporal data type:

```
month(2016.02.14);
// output: 2016.02M

date(2012.06.13 13:30:10);
// output: 2012.06.13

second(2012.06.13 13:30:10);
// output: 13:30:10

timestamp(2012.06.13 13:30:10);
// output: 2012.06.13T13:30:10.000
```

**Parent topic:**[Temporal Objects](../../../Programming/DataManipulation/TemporalObjects/TemporalObjects.md)

