# String Operations {#string-operations}

\(1\) Replace a substring with functions [strReplace](../../../Functions/s/strReplace.md) and [regexReplace](../../../Functions/r/regexReplace.md). With `regexReplace`, we can search a regular expression pattern, and we can also specify a starting position to search.

```
strReplace("this computer is faster than that computer", "computer", "desktop");
// output: this desktop is faster than that desktop

regexReplace("this computer is faster than that computer", "computer", "desktop", 8);
// output: this computer is faster than that desktop

regexReplace("this computer is faster than that computer", "\\b(comp)([^ ]*)", "desktop");
// output: this desktop is faster than that desktop
```

\(2\) Generate a substring starting with the left or the right with functions [left](../../../Functions/l/left.md) or [right](../../../Functions/r/right.md) respectively. Use function [substr](../../../Functions/s/substr.md) or [substru](../../../Functions/s/substru.md)to get a substring with specified starting position and length.

```
left("Hello World", 5);
// output: Hello

right("Hello World", 5);
// output: World

substr("This is a test", 5, 2);
// output: is
```

\(3\) Functions [ltrim](../../../Functions/l/ltrim.md) or [rtrim](../../../Functions/r/rtrim.md) removes the spaces on the left or right end of the string; function [trim](../../../Functions/t/trim.md) removes the spaces on both ends of the string; function [strip](../../../Functions/s/strip.md) removes all space, tab, new line, and carriage characters on both ends of a string.

```
ltrim("     Hello World   ");
// output: Hello World

rtrim("Hello World   ")+"!";
// output: Hello World!

trim("     Hello World   ")+"!";
// output: Hello World!

strip("   \t  Hello World   ");
// output: Hello World
```

\(4\) Pad specified characters to the left or the right side of a string with functions [lpad](../../../Functions/l/lpad.md) and [rpad](../../../Functions/r/rpad.md) respectively.

```
lpad("Hello",7);
// output: Hello

lpad("Hello",7,"0");
// output: 00Hello

rpad("Hello",7,"0");
// output: Hello00
```

\(5\) Repeat a string multiple times with function [repeat](../../../Functions/r/repeat.md) .

```
repeat("ABC",3);
// output: ABCABCABC

repeat(`ABC`DE,3);
// output: ["ABCABCABC","DEDEDE"]
```

\(6\) Convert strings to either lower case or upper case with functions [lower](../../../Functions/l/lower.md) or [upper](../../../Functions/u/upper.md) respectively.

```
lower `Chloe;
// output: chloe

upper 'Christmas';
// output: CHRISTMAS
```

\(7\) Use function [concat](../../../Functions/c/concat.md) to combine 2 strings into one string.

```
concat (`hello, `world);
// output: helloworld
```

To combine multiple strings, we can use the operator "+".

```
var1="Hello"
var2='World'
var1+", "+var2+"!";
// output: Hello, World!
```

\(8\) Use function [split](../../../Functions/s/split.md) to split a string into multiple strings with the specified delimiter.

```
split("xyz 1 ABCD 3241.32"," ");
// output: ["xyz","1","ABCD","3241.32"]

split("XOM|2018.02.15|76.21", "|");
// output: ["XOM","2018.02.15","76.21"]
```

\(9\) To calculate the length of a string, use function [strlen](../../../Functions/s/strlen.md) .

```
strlen("Hello World!");
// output: 12

strlen(`XOM`MSFT`F`GM);
// output: [3,4,1,2]
```

To count the number of words in a string, use function [wc](../../../Functions/w/wc.md) :

```
wc(`apple);
// output: 1

wc("This is a 7th generation iphone!");
// output: 6

wc("This is a 7th generation iphone!" "I wonder what the 8th generation looks like");
// output: [6,8]
```

Use function [regexCount](../../../Functions/r/regexCount.md) to count how many times a string or a regular expression pattern occurs in a string.

```
regexCount("FB IBM FB IBM AMZN IBM", `IBM);
// output: 3

regexCount("FB IBM FB IBM AMZN IBM", `IBM, 7);
// output: 2

regexCount("this subject has a submarine as subsequence", "\\b(sub)([^ ]*)");
// output: 3
```

\(10\) Use functions [startsWith](../../../Functions/s/startsWith.md) and [endsWith](../../../Functions/e/endsWith.md) to test if a string starts or ends with another string.

```
startsWith('ABCDEF!', "ABC");
// output: 1

startsWith('ABCDEF!', "ABD");
// output: 0

endsWith('ABCDEF!', "F!");
// output: 1

endsWith('ABCDEF!', "E!");
// output: 0
```

\(11\) Function [convertEncode](../../../Functions/c/convertEncode.md) changes the encoding of strings. Function [fromUTF8](../../../Functions/f/fromUTF8.md) changes the encoding of strings from UTF-8. Function [toUTF8](../../../Functions/t/toUTF8.md) changes the encoding of strings to UTF-8.

```
convertEncode(["hello","DolphinDB"],"gbk","utf-8");
// output: ["hello","DolphinDB"]

fromUTF8(["hello","DolphinDB"],"gbk");
// output: ["hello","DolphinDB"]

toUTF8(["hello","DolphinDB"],"gbk");
// output: ["hello","DolphinDB"]
```

\(12\) Function [charAt](../../../Functions/c/charAt.md) returns the characters at specified positions in a string.

```
s=charAt("abc",2);
s;
// output: 'c'

typestr(s);
// output: CHAR

charAt(["hello","world"],[3,4]);
// output: ['l','d']
```

\(13\) Function [isAlpha](../../../Functions/i/isAlpha.md) determines whether all characters in a string are alphabets. Function [isUpper](../../../Functions/i/isUpper.md) determines whether all the case-based characters \(letters\) of a string are uppercase. Function [isLower](../../../Functions/i/isLower.md) determines whether all the case-based characters \(letters\) of the string are lowercase. Function [isTitle](../../../Functions/i/isTitle.md) determines whether a string is a titlecased string, which has the first character in each word uppercase and the remaining all characters lowercase alphabets.

```
isAlpha(["hello","hello world","1And1",string()]);
// output: [true,false,false,false]

isUpper("123456ABC");
// output: true

isLower("123456abc");
// output: true

isTitle("Hello World");
// output: true
```

\(14\) Function [isNumeric](../../../Functions/i/isNumeric.md) and[isDigit](../../../Functions/i/isDigit.md) determines if all characters in a string are numbers. Function [isAlNum](../../../Functions/i/isAlNum.md) determines whether all characters in a string are alphanumeric \(either alphabets or numbers\).

```
isNumeric("123456");
// output: true

isDigit("1And1");
// output: false

isDecimal("10.05");
// output: false

isAlNum("123456abc");
// output: true
```

\(15\) Function [isSpace](../../../Functions/i/isSpace.md) determines whether a string consists of only space.

```
isSpace(" \t ");
// output: true
```

**Parent topic:**[String Objects](../../../Programming/DataManipulation/StringObjects/StringObjects.md)

